﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_ResultHandler.h>
#include <nn/fs/fs_MmcPrivate.h>

#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>

void* operator new(size_t size) NN_NOEXCEPT
{
    return malloc(size);
}

void operator delete(void* p) NN_NOEXCEPT
{
    free(p);
}

namespace{

const char TestFileName[]       = "1";

const int DivisionCountMax = 1   * 1024; // 小さいバッファサイズの場合、この数以上の read/write はしない
const int BufferSizeMin    = 1   * 1024;
const int BufferSizeMax    = 4   * 1024 * 1024;

} // namespace

// ROM をマウント後 ROM 内の特定ファイルを各バッファサイズで読み込む時間を計測する
TEST(PerformanceTestReadFixPosPatch, ReadFile)
{
    nnt::fs::util::PerformanceReadTestForPatchedRom(
        TestFileName, BufferSizeMin, BufferSizeMax, DivisionCountMax);
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nnt::fs::util::SetFsTestPerformanceConfiguration();

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nnt::fs::util::ResetAllocateCount();
    nn::fs::SetEnabledAutoAbort(false);

    // MmcPatrol 休止
    nn::fs::SuspendMmcPatrol();

    auto testResult = RUN_ALL_TESTS();

    // MmcPatrol 再開
    nn::fs::ResumeMmcPatrol();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(testResult);
}
