﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_ResultHandler.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util_DynamicModule.h>

int GetVersion() NN_NOEXCEPT;

TEST(PatchAddRo, Version2)
{
    const int Version = 2;

    char nroPath[256];
    nn::util::SNPrintf(nroPath, sizeof(nroPath), "rom:/nro/PatchAddRoV%d.nro", Version);

    nnt::fs::util::ScopedDynamicModuleLoader loader;
    NNT_ASSERT_RESULT_SUCCESS(loader.Load("rom", "rom:/.nrr/PatchAddRo.nrr", nroPath));

    ASSERT_EQ(Version, GetVersion());
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nn::fs::SetEnabledAutoAbort(false);

    int result = RUN_ALL_TESTS();

    nnt::Exit(result);
}
