﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nn/fs/fs_ResultHandler.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>

TEST(PatchAddRo, NoRo)
{
    size_t cacheBufferSize = 0;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountRomCacheSize(&cacheBufferSize));

    auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
    ASSERT_NE(nullptr, cacheBuffer);

    NNT_ASSERT_RESULT_FAILURE(
        nn::fs::ResultPartitionNotFound,
        nn::fs::MountRom("rom", cacheBuffer.get(), cacheBufferSize));
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nn::fs::SetEnabledAutoAbort(false);

    int result = RUN_ALL_TESTS();

    nnt::Exit(result);
}
