$scriptDirPath = Split-Path $myInvocation.MyCommand.path
# $genFileTreeScriptPath = $scriptDirPath + "\ListUpRandomFiles.ps1"
# . $genFileTreeScriptPath
# Add-Type -ReferencedAssemblies $assemblies -TypeDefinition $source -Language CSharp
$genFileTreePath = $scriptDirPath + "\ListUpRandomFiles.exe"

$nspPath  = (Convert-Path ./Tests/Outputs/NX-NXFP2-a64/Tests/testFs_Integration_Aging/Develop/testFs_Integration_Aging.nsp)
$KeywordPassed   = "[  PASSED  ]"

$keyConfigPath = "./Tools/CommandLineTools/AuthoringTool/AuthoringTool.repository.keyconfig.xml"
$nspAdfPath = $nspPath + ".adf"
$romAdfPath = $nspPath + ".c0.Program.nca.rom.adf"
echo "nspAdfPath: '$nspAdfPath'"
echo "romAdfPath: '$romAdfPath'"

if(-not (Test-Path $nspAdfPath) -or -not (Test-Path $romAdfPath))
{
    echo "'$nspAdfPath' or '$romAdfPath' are missing"
    exit 1
}

$isDebug = $FALSE
$isDebug = $TRUE
$randomseed = 0
$rand = new-object random($randomseed)
$count = 0

while(1)
{
	echo "#### try count: $count"
	$count += 1

    ## t@Cc[Lq adf t@C쐬
    $depth   = $rand.next(1,100); echo "depth: $depth"
    $fileNum = $rand.next(10,100000); echo "FileNum: $fileNum"
    $dirRate = 2
    $totalSize = $rand.next(1, 25 * 1024 * 1024) * 1024L; echo "TotalSize: $totalSize"

	if($isDebug) {
		echo "Info: re-assign values for debug"
		$fileNum = $rand.next(10,100); echo "FileNum: $fileNum"
		$totalSize = $rand.next(128, 1 * 1024); echo "TotalSize: $totalSize"
	}
    # [Program]::OutputAdf($romAdfPath, "", $fileNum, $totalSize, $depth, $dirRate, "Random")
    Start-Process -FilePath $genFileTreePath -Wait -NoNewWindow -ArgumentList "$romAdfPath","/","$fileNum","$totalSize","$depth","$dirRate","Random"

    ## nsp 쐬
	echo "### Creating nsp..."
    Tools\CommandLineTools\AuthoringTool\AuthoringTool.exe creatensp $nspAdfPath -o $nspPath --keyconfig $keyConfigPath

    ## GC ݁ENE㏈
	echo "### Run on GC"
    Tools\CommandLineTools\RunOnTarget.exe Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp -- gamecard write $nspPath
    $log = Tools\CommandLineTools\RunOnTarget.exe gamecard
    if(-not ([string]$log).Contains($KeywordPassed)){
      echo "### -------------------- FAILED! ---------------------- ###"
      echo $log
      break
    }
	else {
		$loglen = ($log).Length
		echo "# PASS (log $loglen bytes discarded)"
	}
    Tools\CommandLineTools\RunOnTarget.exe Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp -- gamecard erase
    Tools\CommandLineTools\RunOnTarget.exe Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp -- application uninstall 0x010000000000B1C6
	Get-Process NintendoTargetManager | Stop-Process

    ## NAND ݁ENE㏈
	echo "### Run on NAND"
    Tools\CommandLineTools\RunOnTarget.exe Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp -- application install $nspPath
    $log = Tools\CommandLineTools\RunOnTarget.exe 0x010000000000B1C6
    if(-not ([string]$log).Contains($KeywordPassed)){
      echo "### -------------------- FAILED! ---------------------- ###"
      echo $log
      break
    }
	else {
		$loglen = ($log).Length
		echo "# PASS (log $loglen bytes discarded)"
	}
    Tools\CommandLineTools\RunOnTarget.exe Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp -- application uninstall 0x010000000000B1C6
	Get-Process NintendoTargetManager | Stop-Process

    ## SD J[h ݁ENE㏈
	echo "### Run on SD"
	Tools/CommandLineTools/RunOnTarget.exe "Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommand/Develop/DevMenuCommand.nsp" "--" "application" "install" "$nspPath" "-s" "sdcard" "--force"
    $log = Tools\CommandLineTools\RunOnTarget.exe 0x010000000000B1C6
    if(-not ([string]$log).Contains($KeywordPassed)){
      echo "### -------------------- FAILED! ---------------------- ###"
      echo $log
      break
    }
	else {
		$loglen = ($log).Length
		echo "# PASS (log $loglen bytes discarded)"
	}
    Tools\CommandLineTools\RunOnTarget.exe Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp -- application uninstall 0x010000000000B1C6
	Get-Process NintendoTargetManager | Stop-Process
}