$assemblies = (
 "System"
)

$source = @"
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

    public static class Program
    {
        enum FileSizeDistribution
        {
            Random,
            Uniform,
            SparseMiddle,
        };

        struct TreeInfo
        {
            public long totalSize;
            public int fileCount;
            public int directoryCount;
        }

        static readonly long MaxFileSize = 2 * 1024L * 1024L * 1024L;
        static Random rnd = new System.Random(0);

        static Dictionary<string, int> GenerateRandomWords(int minLength, int maxLength, int wordCount)
        {
            return GenerateRandomWords(minLength, maxLength, wordCount, null);
        }
        static Dictionary<string, int> GenerateRandomWords(int minLength, int maxLength, int wordCount, Dictionary<string, int> dict)
        {
            Random random = new System.Random(0);
            var wordDict = new Dictionary<string, int>();
            const string candidates = "abcdefghijklmnopqrstuvwxyz0123456789._-";
            for (int i = 0; i < wordCount; )
            {
                var word = new char[rnd.Next(minLength, maxLength + 1)];
                for (int jj = 0; jj < word.Length; jj++)
                {
                    word[jj] = candidates[rnd.Next(candidates.Length)];
                }
                string sword = new string(word);
                if(wordDict.ContainsKey(sword) || (dict != null && dict.ContainsKey(sword)))
                {
                    continue;
                }
                wordDict[sword] = 0;
                i++;
            }
            return wordDict;
        }

        static List<string> GenerateUniqueWords(int startValue, int wordCount)
        {
            const string candidates = "abcdefghijklmnopqrstuvwxyz0123456789.-";

            var pool = new List<string>();
            for (int i = startValue; i < wordCount + startValue; i++)
            {
                var word = new char[rnd.Next(1, 10)];
                for (int jj = 0; jj < word.Length; jj++)
                {
                    word[jj] = candidates[rnd.Next(candidates.Length)];
                }
                pool.Add(new string(word) + "_" + i.ToString());
            }

            return pool;
        }

        // 返り値：ファイルサイズ
        static void OutputRandomFile(string path, string name, long size, long offset)
        {
            var filePath = path + '/' + name;
            // Console.WriteLine("file: '{0}' ({1} byte)", filePath, size);

            var entryStr = string.Format(@"  - type : file
    name : {0}
    offset : {1}
    path : {2}
    specifiedsize : {3}
    sourceType : padding", filePath, offset, filePath, size);
            Console.WriteLine(entryStr);
        }
        // 返り値：ディレクトリパス
        static string OutputRandomDirectory(string path, string name)
        {
            var dirPath = name;
            if (path.IndexOf('/') >= 0)
            {
                dirPath = string.Format("{0}/{1}", path, name);
            }
            // Console.WriteLine("directory: '{0}'", dirPath);
            return dirPath;
        }

        static long CreateNewTree(string basePath, int fileCount, long totalSize, int maxDepth, int directoryRate, FileSizeDistribution distribution)
        {
            TreeInfo globalTreeInfo;
            globalTreeInfo.totalSize = 0;
            globalTreeInfo.fileCount = 0;
            globalTreeInfo.directoryCount = 0;
            return CreateNewTree(ref globalTreeInfo, basePath, fileCount, totalSize, maxDepth, directoryRate, distribution);
        }
        static long CreateNewTree(ref TreeInfo globalTreeInfo, string basePath, int fileCount, long totalSize, int maxDepth, int directoryRate, FileSizeDistribution distribution)
        {
            // string indent = new string(' ', (5 - maxDepth) * 2);
            // Console.WriteLine(indent + "CreateNewTree - maxDepth: {0}, fileCount: {1}, totalSize: {2}", maxDepth, fileCount, totalSize);
            long targetTotalSize = totalSize;

            // 適当な数だけディレクトリを作成し、再帰的にツリー構造を作成
            int directoryCount = 0;
            if (maxDepth > 0 && totalSize > 0)
            {
                directoryCount = rnd.Next(fileCount / directoryRate);
            }
            // TORIAEZU:
            // var dirWordPool = GenerateUniqueWords(0, directoryCount);
            var dirWordPool = GenerateUniqueWords(globalTreeInfo.fileCount + globalTreeInfo.directoryCount, directoryCount);

            if (directoryCount > 0)
            {
                // Console.WriteLine(indent + "directoryCount: {0}", directoryCount);

                for (int i = 0; i < directoryCount; i++)
                {
                    // TORIAEZU:
                    int subFileCount = rnd.Next(fileCount);
                    long subTotalSize = (long)(totalSize * rnd.NextDouble());

                    var childDirPath = OutputRandomDirectory(basePath, dirWordPool[i]);
                    globalTreeInfo.directoryCount++;

                    var childTotalSize = CreateNewTree(ref globalTreeInfo, childDirPath, subFileCount, subTotalSize, maxDepth - 1, directoryRate, distribution);

                    fileCount -= subFileCount;
                    totalSize -= childTotalSize;
                }
            }

            var fileWordPool = GenerateUniqueWords(dirWordPool.Count, fileCount);

            // 残りの数だけファイルを作成
            if (fileCount > 0)
            {
                // Console.WriteLine(indent + "fileCount: {0}", fileCount);

                for (int i = 0; i < fileCount; i++)
                {
                    // ファイルサイズは分布に従う
                    long childFileSize = 0;

                    // 突き抜けは許さない
                    Debug.Assert(totalSize >= 0);
                    if(totalSize <= 0)
                    {
                        fileCount = 0;
                        break;
                    }

                    switch (distribution)
                    {
                        case FileSizeDistribution.Uniform:
                            long expectedSize = (totalSize - 1) / (fileCount - i);
                            childFileSize = 1 + (long)(expectedSize * Math.Min(1.0, 5.0 * rnd.NextDouble()));
                            break;
                        case FileSizeDistribution.Random:
                            childFileSize = 1 + (long)((totalSize - 1) * rnd.NextDouble());
                            break;
                        case FileSizeDistribution.SparseMiddle:
                            double rvalue = rnd.NextDouble();
                            for (int jj = 0; jj < 1 + rnd.Next(2); jj++)
                            {
                                rvalue *= rnd.NextDouble();
                            }
                            if (rnd.Next(2) == 0)
                            {
                                rvalue = 1.0 - rvalue;
                            }
                            childFileSize = 1 + (long)((totalSize - 1) * rvalue);
                            break;
                        default:
                            throw new NotSupportedException("Unknown value for FileSizeDistribution");
                    }
                    Debug.Assert(childFileSize >= 0);
                    childFileSize = Math.Min(MaxFileSize, childFileSize);

                    OutputRandomFile(basePath, fileWordPool[i], childFileSize, globalTreeInfo.totalSize);
                    totalSize -= childFileSize;
                    fileCount--;

                    globalTreeInfo.totalSize += childFileSize;
                    globalTreeInfo.fileCount++;
                }
            }

            // Console.WriteLine(indent + "---");
            return targetTotalSize - totalSize;
        }

        public static void OutputAdf(string outputPath, string basePath, int fileCount, long totalSize, int maxDepth, int directoryRate, string distribution)
        {
            using (var writer = new System.IO.StreamWriter(outputPath))
            {
                Console.SetOut(writer);
                Console.WriteLine(@"formatType : RomFs
version : 0
entries :");
                // TORIAEZU
                var dtype = (FileSizeDistribution)Enum.Parse(typeof(FileSizeDistribution), distribution);
                var actualTotalSize = CreateNewTree(basePath, fileCount, totalSize, maxDepth, directoryRate, dtype);
                // Console.WriteLine("total {0} byte", actualTotalSize);

                writer.Flush();
            }

            using (System.IO.StreamWriter std = new System.IO.StreamWriter(Console.OpenStandardOutput()))
            {
                std.AutoFlush = true;
                Console.SetOut(std);
            }
        }
    }
"@

