﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_PriorityPrivate.h>
#include <nn/os/os_ThreadApi.h>

#include <shim/fs_FileSystemProxyServiceObject.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>

namespace
{
    const int SessionCountMax = 16;
}

TEST(AccessPriority, SessionCountOverLimit)
{
    for( int sessionCount = 1; sessionCount <= SessionCountMax; ++sessionCount )
    {
        NN_LOG("try session count %d\n", sessionCount + SessionCountMax);

        nn::fs::detail::DisableSessionForRealtimeOnlyAndChangeSessionCount(sessionCount);
        NN_UTIL_SCOPE_EXIT
        {
            nnt::fs::util::RevertSessionSettingToDefault();
        };

        size_t sizeRomCache;
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountRomCacheSize(&sizeRomCache));
    }
}

TEST(AccessPriority, KeepSessionMax)
{
    nn::fs::detail::DisableSessionForRealtimeOnlyAndChangeSessionCount(SessionCountMax);
    for( ;; )
    {
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }
}

TEST(AccessPriority, SetInvalidValue1)
{
    nn::fs::SetPriorityOnCurrentThread(static_cast<nn::fs::Priority>(-1));
}

TEST(AccessPriority, SetInvalidValue2)
{
    nn::fs::SetPriorityOnCurrentThread(static_cast<nn::fs::Priority>(3));
}

TEST(AccessPriority, SetInvalidValue3)
{
    nn::fs::SetPriorityRawOnCurrentThread(static_cast<nn::fs::PriorityRaw>(-1));
}

TEST(AccessPriority, SetInvalidValue4)
{
    nn::fs::SetPriorityRawOnCurrentThread(static_cast<nn::fs::PriorityRaw>(5));
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    nnt::fs::util::AbortDisabler disableAbort;

    ::testing::InitGoogleTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    (void)nn::fs::detail::GetFileSystemProxyServiceObject();

    auto testResult = RUN_ALL_TESTS();

    nnt::Exit(testResult);
}
