﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_ImageDirectory.h>

#include "testFs_FsLib_Mount.h"

TEST(Mount, MountImageDirectory)
{
    const nn::fs::ImageDirectoryId Ids[] =
    {
        nn::fs::ImageDirectoryId::Nand,
        nn::fs::ImageDirectoryId::SdCard,
    };

    for( auto id : Ids )
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountImageDirectory("dcim", id));

        nnt::fs::util::DumpDirectoryRecursive("dcim:/");
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::CreateFile("dcim:/test.file", 32));
        nnt::fs::util::DumpDirectoryRecursive("dcim:/");

        NNT_EXPECT_RESULT_SUCCESS(nn::fs::DeleteFile("dcim:/test.file"));

        nn::fs::Unmount("dcim");
    }

}

namespace
{
    template<nn::fs::ImageDirectoryId Id>
    nn::Result MountImageDirectoryForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        NN_RESULT_DO(nn::fs::MountImageDirectory(mountName, Id));
        NN_RESULT_SUCCESS;
    }

    const nnt::fs::util::MountTestParameter MountTestParameters[] = {
        { "MountImageDirectory(Nand)", MountImageDirectoryForMountNameTest<nn::fs::ImageDirectoryId::Nand> },
        { "MountImageDirectory(SdCard)", MountImageDirectoryForMountNameTest<nn::fs::ImageDirectoryId::SdCard> }
    };
}

NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(WithMountImageDirectory, ::testing::ValuesIn(MountTestParameters));
