﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsApi/testFs_Api.h>

namespace nnt { namespace fs { namespace api {
    void LoadOperateRangeTests() NN_NOEXCEPT
    {
        return;
    }

    class OperateRange : public CleanupFileSystemTestFixture
    {
    protected:
        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            CleanupFileSystemTestFixture::SetUp();
            m_FileName = GetTestRootPath().append("/test.file");
        }
        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
        {
            CleanupFileSystemTestFixture::TearDown();
        }

        const nnt::fs::util::String& GetFileName() NN_NOEXCEPT
        {
            return m_FileName;
        }

    private:
        nnt::fs::util::String m_FileName;
    };

    //!< @brief QueryRange の挙動が正しく動作していること
    TEST_F(OperateRange, QueryRange)
    {
        const auto FileSize =
            (GetFsAttribute()->isMemoryStorage
                && GetFsAttribute()->fileSizeMax >= static_cast<int64_t>(64) * 1024 * 1024 * 1024
                && GetFsAttribute()->storageSize >= static_cast<int64_t>(64) * 1024 * 1024 * 1024)
            ? static_cast<int64_t>(64) * 1024 * 1024 * 1024
            : 1024;

        // ファイル作成
        NNT_ASSERT_RESULT_SUCCESS(GetFs().CreateFile(GetFileName().c_str(), FileSize));
        NN_UTIL_SCOPE_EXIT
        {
            // ファイル削除
            NNT_ASSERT_RESULT_SUCCESS(GetFs().DeleteFile(GetFileName().c_str()));
        };

        // ファイルオープン
        std::unique_ptr<ITestFile> file;

        NNT_ASSERT_RESULT_SUCCESS(
            GetFs().OpenFile(
                &file,
                GetFileName().c_str(),
                static_cast<nn::fs::OpenMode>(
                    nn::fs::OpenMode::OpenMode_Read |
                    nn::fs::OpenMode::OpenMode_Write |
                    nn::fs::OpenMode::OpenMode_AllowAppend)
            )
        );

        nn::fs::QueryRangeInfo info;

        if( GetFsAttribute()->isSupportedQueryRange )
        {
            NNT_ASSERT_RESULT_SUCCESS(file->QueryRange(&info, 0, FileSize));
            EXPECT_EQ(GetFsAttribute()->aesCtrKeyTypeFlag, info.aesCtrKeyTypeFlag);
            EXPECT_EQ(GetFsAttribute()->speedEmulationTypeFlag, info.speedEmulationTypeFlag);
        }
        else
        {
            NNT_ASSERT_RESULT_FAILURE(nn::fs::ResultUnsupportedOperation,
                file->QueryRange(&info, 0, FileSize));
        }
    }

}}}
