﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testFriends_Common.h"

#include <nn/friends/detail/util/friends_LanguageCode.h>

TEST(FriendsLanguageCode, Standard)
{
    nn::settings::LanguageCode languages[] =
    {
        {"ja"},
        {"en-US"},
        {"fr"},
        {"de"},
        {"it"},
        {"es"},
        {"zh-CN"},
        {"ko"},
        {"nl"},
        {"pt"},
        {"ru"},
        {"zh-TW"},
        {"en-GB"},
        {"fr-CA"},
        {"es-419"},
        {}
    };

    for (int i = 0; languages[i].string[0] != '\0'; i++)
    {
        EXPECT_TRUE(nn::friends::detail::util::VerifyLanguageCode(languages[i]));
    }

    nn::settings::LanguageCode empty = {};
    EXPECT_TRUE(nn::friends::detail::util::VerifyLanguageCode(empty));
}

TEST(FriendsLanguageCode, Valid)
{
    nn::settings::LanguageCode languages[] =
    {
        {"aa"},
        {"aaa"},
        {"aa-bb"},
        {"aa-bbbb"},
        {"aaa-bb"},
        {"aaa-000"},
        {}
    };

    for (int i = 0; languages[i].string[0] != '\0'; i++)
    {
        EXPECT_TRUE(nn::friends::detail::util::VerifyLanguageCode(languages[i]));
    }
}

TEST(FriendsLanguageCode, Invalid)
{
    nn::settings::LanguageCode languages[] =
    {
        {"a"},
        {"aaaa"},
        {"aaaaaaa"},
        {"aa-"},
        {"aa-b"},
        {"aa-bbb"},
        {"aa-0"},
        {"aa-00"},
        {"aa-0000"},
        {"0"},
        {"a0"},
        {"aa0"},
        {"aa!"},
        {"+"},
        {"++"},
        {"++-bb"},
        {"++-000"},
        {}
    };

    for (int i = 0; languages[i].string[0] != '\0'; i++)
    {
        EXPECT_FALSE(nn::friends::detail::util::VerifyLanguageCode(languages[i]));
    }

    nn::settings::LanguageCode overflow = {"aa-bbbb"};
    overflow.string[7] = 'b';

    EXPECT_FALSE(nn::friends::detail::util::VerifyLanguageCode(overflow));
}
