﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>

namespace nnt { namespace friends {

/*!
    @brief      入力モジュールを初期化します。
*/
void InitializePad() NN_NOEXCEPT;

/*!
    @brief      ボタン入力を取得します。

    @param[out] pButtons    ボタン入力。

    @pre
        - pButtons != nullptr

    @details
                本関数は以下の優先度でボタン入力を取得します。

                # フルキー操作のボタン入力の取得
                # 携帯機操作のボタン入力の取得
                # DebugPad のボタン入力の取得
*/
void GetNpadButtons(nn::hid::NpadButtonSet* pButtons) NN_NOEXCEPT;

}}
