﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished proprietary information of BroadOn Communications Corp.,
 *  and are protected by Federal copyright law. They may not be disclosed
 *  to third parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <nnt/nntest.h>

#define TESTNAME "RsaVerTest"
#define NEED_NUMTICKS

#include "testEs_Testcommon.h"

#include <nn/ioscrypto/iosccert.h>

#if defined( USE_BSAFE )
#include <twl/crypto/rsa.h>
#include "pub1024.c"
#include "sign1024.c"
#include "data1024.c"
#include "pub2048.c"
#include "sign2048.c"
#include "data2048.c"
#include "pub4096.c"
#include "sign4096.c"
#include "data4096.c"
#endif
#if defined( MEASURE_PERF )
#include <nitro/crypto.h>
#endif

#define ERROR_CHECK( err )                               \
    if( err != IOSC_ERROR_OK )                           \
    {                                                    \
        TUL_LogFail( TESTNAME, "error in IOSC call\n" ); \
        EXIT( -1 );                                      \
    }

#define EXPECT_OK( err, msg )  \
    if( err == IOSC_ERROR_OK ) \
    {                          \
        LOG_PASS( msg );       \
    }                          \
    else                       \
    {                          \
        LOG_FAIL( msg );       \
        EXIT( -1 );            \
    }

#define EXPECT_NOT_OK( err, msg ) \
    if( err != IOSC_ERROR_OK )    \
    {                             \
        LOG_PASS( msg );          \
    }                             \
    else                          \
    {                             \
        LOG_FAIL( msg );          \
        EXIT( -1 );               \
    }

extern void *MyAlloc( u32 size );
extern void MyFree( void *ptr );
extern void *MyRealloc( void *ptr, u32 new_size, u32 old_size );

extern int doRsaVerTest( void );

int doRsaVerTest()
{
    u8 hash_data[20];
    u8 sign[512];
    u8 n[512];
    u8 eExt[4];
#if defined( USE_BSAFE )
    CRYPTORSAVerifyInitParam verifyInitParam;
    CRYPTORSAVerifyParam verifyParam;
    CRYPTORSASignContext signContext;
#endif

    IOSCError err;
    IOSCPublicKeyHandle pubh;

    eExt[0] = 0x0;
    eExt[1] = 0x1;
    eExt[2] = 0x0;
    eExt[3] = 0x1;

    /* 4096 bit test */
    hash_data[0] = 0xa5;
    hash_data[1] = 0x0b;
    hash_data[2] = 0x5c;
    hash_data[3] = 0x86;
    hash_data[4] = 0xe7;
    hash_data[5] = 0x92;
    hash_data[6] = 0xa0;
    hash_data[7] = 0x67;
    hash_data[8] = 0x16;
    hash_data[9] = 0x6f;
    hash_data[10] = 0x4c;
    hash_data[11] = 0xed;
    hash_data[12] = 0xfc;
    hash_data[13] = 0xa1;
    hash_data[14] = 0xab;
    hash_data[15] = 0x97;
    hash_data[16] = 0x85;
    hash_data[17] = 0x28;
    hash_data[18] = 0x7c;
    hash_data[19] = 0x48;

    sign[0] = 0x75;
    sign[1] = 0x97;
    sign[2] = 0x54;
    sign[3] = 0x12;
    sign[4] = 0x0d;
    sign[5] = 0x68;
    sign[6] = 0x95;
    sign[7] = 0xd0;
    sign[8] = 0xab;
    sign[9] = 0x72;
    sign[10] = 0x7a;
    sign[11] = 0x3f;
    sign[12] = 0x51;
    sign[13] = 0x3d;
    sign[14] = 0x61;
    sign[15] = 0x0a;
    sign[16] = 0xff;
    sign[17] = 0xfa;
    sign[18] = 0x41;
    sign[19] = 0x03;
    sign[20] = 0xd1;
    sign[21] = 0x39;
    sign[22] = 0xd5;
    sign[23] = 0x05;
    sign[24] = 0x9a;
    sign[25] = 0x9f;
    sign[26] = 0x33;
    sign[27] = 0x3f;
    sign[28] = 0x9e;
    sign[29] = 0xbc;
    sign[30] = 0xcd;
    sign[31] = 0xee;
    sign[32] = 0xa7;
    sign[33] = 0xdc;
    sign[34] = 0x7d;
    sign[35] = 0xe4;
    sign[36] = 0x97;
    sign[37] = 0x4d;
    sign[38] = 0x8f;
    sign[39] = 0xf4;
    sign[40] = 0x4b;
    sign[41] = 0x47;
    sign[42] = 0xbb;
    sign[43] = 0xe7;
    sign[44] = 0xa9;
    sign[45] = 0x85;
    sign[46] = 0x67;
    sign[47] = 0xb1;
    sign[48] = 0xeb;
    sign[49] = 0x36;
    sign[50] = 0xef;
    sign[51] = 0x15;
    sign[52] = 0xe8;
    sign[53] = 0xf6;
    sign[54] = 0xdc;
    sign[55] = 0x6b;
    sign[56] = 0x18;
    sign[57] = 0x90;
    sign[58] = 0xf6;
    sign[59] = 0x6e;
    sign[60] = 0xde;
    sign[61] = 0xce;
    sign[62] = 0x03;
    sign[63] = 0x9e;
    sign[64] = 0xb7;
    sign[65] = 0xe4;
    sign[66] = 0xef;
    sign[67] = 0x98;
    sign[68] = 0x09;
    sign[69] = 0xd1;
    sign[70] = 0xa0;
    sign[71] = 0xc4;
    sign[72] = 0x65;
    sign[73] = 0x16;
    sign[74] = 0xf2;
    sign[75] = 0x54;
    sign[76] = 0x53;
    sign[77] = 0x6f;
    sign[78] = 0x1d;
    sign[79] = 0x5d;
    sign[80] = 0x94;
    sign[81] = 0x87;
    sign[82] = 0xc4;
    sign[83] = 0x06;
    sign[84] = 0x54;
    sign[85] = 0xcb;
    sign[86] = 0x5b;
    sign[87] = 0x02;
    sign[88] = 0xe5;
    sign[89] = 0x47;
    sign[90] = 0x0e;
    sign[91] = 0x45;
    sign[92] = 0x15;
    sign[93] = 0xfa;
    sign[94] = 0x46;
    sign[95] = 0xc9;
    sign[96] = 0x14;
    sign[97] = 0x62;
    sign[98] = 0x2f;
    sign[99] = 0x79;
    sign[100] = 0x9e;
    sign[101] = 0xd6;
    sign[102] = 0xf8;
    sign[103] = 0x2d;
    sign[104] = 0x40;
    sign[105] = 0x06;
    sign[106] = 0x2e;
    sign[107] = 0xc3;
    sign[108] = 0xd8;
    sign[109] = 0x5e;
    sign[110] = 0x13;
    sign[111] = 0x67;
    sign[112] = 0x7c;
    sign[113] = 0x6a;
    sign[114] = 0x44;
    sign[115] = 0x22;
    sign[116] = 0x74;
    sign[117] = 0xc4;
    sign[118] = 0xe4;
    sign[119] = 0x4f;
    sign[120] = 0xba;
    sign[121] = 0xe4;
    sign[122] = 0xb3;
    sign[123] = 0x8e;
    sign[124] = 0x58;
    sign[125] = 0xa6;
    sign[126] = 0x0f;
    sign[127] = 0x7e;
    sign[128] = 0x6e;
    sign[129] = 0x70;
    sign[130] = 0x98;
    sign[131] = 0xc8;
    sign[132] = 0xa1;
    sign[133] = 0x72;
    sign[134] = 0x77;
    sign[135] = 0xb8;
    sign[136] = 0x0c;
    sign[137] = 0x77;
    sign[138] = 0x3d;
    sign[139] = 0xfc;
    sign[140] = 0x1c;
    sign[141] = 0x2d;
    sign[142] = 0xd7;
    sign[143] = 0x1b;
    sign[144] = 0x4f;
    sign[145] = 0x7a;
    sign[146] = 0x7d;
    sign[147] = 0xaa;
    sign[148] = 0x07;
    sign[149] = 0x9a;
    sign[150] = 0x9e;
    sign[151] = 0x2c;
    sign[152] = 0x2c;
    sign[153] = 0x16;
    sign[154] = 0x34;
    sign[155] = 0x09;
    sign[156] = 0x81;
    sign[157] = 0x07;
    sign[158] = 0x4d;
    sign[159] = 0x2b;
    sign[160] = 0xcc;
    sign[161] = 0x36;
    sign[162] = 0x87;
    sign[163] = 0x30;
    sign[164] = 0x9e;
    sign[165] = 0x8c;
    sign[166] = 0x51;
    sign[167] = 0x44;
    sign[168] = 0xc4;
    sign[169] = 0x31;
    sign[170] = 0xd2;
    sign[171] = 0x1c;
    sign[172] = 0x95;
    sign[173] = 0x39;
    sign[174] = 0xd1;
    sign[175] = 0x43;
    sign[176] = 0x8e;
    sign[177] = 0x0b;
    sign[178] = 0x0b;
    sign[179] = 0xcd;
    sign[180] = 0x1c;
    sign[181] = 0x40;
    sign[182] = 0xb6;
    sign[183] = 0x1c;
    sign[184] = 0xe8;
    sign[185] = 0xca;
    sign[186] = 0xeb;
    sign[187] = 0xa0;
    sign[188] = 0xe8;
    sign[189] = 0x62;
    sign[190] = 0xe6;
    sign[191] = 0x0f;
    sign[192] = 0xaf;
    sign[193] = 0x61;
    sign[194] = 0x72;
    sign[195] = 0x8c;
    sign[196] = 0x3b;
    sign[197] = 0xea;
    sign[198] = 0xc4;
    sign[199] = 0x44;
    sign[200] = 0x78;
    sign[201] = 0xb5;
    sign[202] = 0x8c;
    sign[203] = 0xa8;
    sign[204] = 0xd5;
    sign[205] = 0x51;
    sign[206] = 0x44;
    sign[207] = 0xa1;
    sign[208] = 0xe4;
    sign[209] = 0x5a;
    sign[210] = 0x02;
    sign[211] = 0xd2;
    sign[212] = 0xde;
    sign[213] = 0xd9;
    sign[214] = 0x5d;
    sign[215] = 0x3a;
    sign[216] = 0x8e;
    sign[217] = 0x13;
    sign[218] = 0xe3;
    sign[219] = 0xe0;
    sign[220] = 0xcd;
    sign[221] = 0x96;
    sign[222] = 0x62;
    sign[223] = 0x29;
    sign[224] = 0xae;
    sign[225] = 0xcc;
    sign[226] = 0x4e;
    sign[227] = 0x3b;
    sign[228] = 0x5c;
    sign[229] = 0x0f;
    sign[230] = 0x8d;
    sign[231] = 0xd0;
    sign[232] = 0xb6;
    sign[233] = 0xd1;
    sign[234] = 0x39;
    sign[235] = 0xbe;
    sign[236] = 0x74;
    sign[237] = 0xaf;
    sign[238] = 0xf6;
    sign[239] = 0xd6;
    sign[240] = 0x04;
    sign[241] = 0xf2;
    sign[242] = 0x78;
    sign[243] = 0xc9;
    sign[244] = 0x3d;
    sign[245] = 0xdf;
    sign[246] = 0x53;
    sign[247] = 0xde;
    sign[248] = 0x53;
    sign[249] = 0x60;
    sign[250] = 0x57;
    sign[251] = 0x0a;
    sign[252] = 0xc9;
    sign[253] = 0xe7;
    sign[254] = 0xcd;
    sign[255] = 0x26;
    sign[256] = 0x5f;
    sign[257] = 0x83;
    sign[258] = 0x85;
    sign[259] = 0x93;
    sign[260] = 0x20;
    sign[261] = 0x47;
    sign[262] = 0xfd;
    sign[263] = 0x4a;
    sign[264] = 0xcd;
    sign[265] = 0x93;
    sign[266] = 0xa4;
    sign[267] = 0xdd;
    sign[268] = 0x56;
    sign[269] = 0xe6;
    sign[270] = 0xe0;
    sign[271] = 0x61;
    sign[272] = 0xfb;
    sign[273] = 0xb9;
    sign[274] = 0xbc;
    sign[275] = 0xc3;
    sign[276] = 0x4e;
    sign[277] = 0x64;
    sign[278] = 0xe3;
    sign[279] = 0x4a;
    sign[280] = 0x21;
    sign[281] = 0x1c;
    sign[282] = 0x2d;
    sign[283] = 0x8a;
    sign[284] = 0x45;
    sign[285] = 0xda;
    sign[286] = 0xc9;
    sign[287] = 0xef;
    sign[288] = 0xa6;
    sign[289] = 0x4b;
    sign[290] = 0x43;
    sign[291] = 0x56;
    sign[292] = 0x95;
    sign[293] = 0xb5;
    sign[294] = 0x90;
    sign[295] = 0x71;
    sign[296] = 0x14;
    sign[297] = 0x29;
    sign[298] = 0xc6;
    sign[299] = 0x1c;
    sign[300] = 0x0d;
    sign[301] = 0x43;
    sign[302] = 0xd9;
    sign[303] = 0xbd;
    sign[304] = 0x87;
    sign[305] = 0x11;
    sign[306] = 0x95;
    sign[307] = 0x4a;
    sign[308] = 0x80;
    sign[309] = 0x4e;
    sign[310] = 0xb6;
    sign[311] = 0x95;
    sign[312] = 0x05;
    sign[313] = 0xd0;
    sign[314] = 0x1a;
    sign[315] = 0x7e;
    sign[316] = 0x21;
    sign[317] = 0x0d;
    sign[318] = 0xab;
    sign[319] = 0x7c;
    sign[320] = 0x23;
    sign[321] = 0x5c;
    sign[322] = 0xb2;
    sign[323] = 0x76;
    sign[324] = 0xdf;
    sign[325] = 0xae;
    sign[326] = 0x0c;
    sign[327] = 0xe0;
    sign[328] = 0xca;
    sign[329] = 0xec;
    sign[330] = 0xbd;
    sign[331] = 0x4c;
    sign[332] = 0x82;
    sign[333] = 0x11;
    sign[334] = 0x91;
    sign[335] = 0x91;
    sign[336] = 0x12;
    sign[337] = 0x6f;
    sign[338] = 0xd1;
    sign[339] = 0xfd;
    sign[340] = 0xb8;
    sign[341] = 0x11;
    sign[342] = 0x57;
    sign[343] = 0x3e;
    sign[344] = 0x2f;
    sign[345] = 0x3d;
    sign[346] = 0x2e;
    sign[347] = 0xfc;
    sign[348] = 0x77;
    sign[349] = 0x00;
    sign[350] = 0xa5;
    sign[351] = 0x50;
    sign[352] = 0x1e;
    sign[353] = 0x4c;
    sign[354] = 0x6b;
    sign[355] = 0x35;
    sign[356] = 0x38;
    sign[357] = 0xc3;
    sign[358] = 0x07;
    sign[359] = 0x85;
    sign[360] = 0x1b;
    sign[361] = 0xe5;
    sign[362] = 0x0c;
    sign[363] = 0x77;
    sign[364] = 0x46;
    sign[365] = 0x22;
    sign[366] = 0x0f;
    sign[367] = 0x88;
    sign[368] = 0x37;
    sign[369] = 0xff;
    sign[370] = 0x79;
    sign[371] = 0x36;
    sign[372] = 0x83;
    sign[373] = 0x0a;
    sign[374] = 0x1c;
    sign[375] = 0xcb;
    sign[376] = 0xaf;
    sign[377] = 0xba;
    sign[378] = 0x84;
    sign[379] = 0x30;
    sign[380] = 0x68;
    sign[381] = 0x1b;
    sign[382] = 0x6d;
    sign[383] = 0x10;
    sign[384] = 0x04;
    sign[385] = 0xa4;
    sign[386] = 0xf6;
    sign[387] = 0xf4;
    sign[388] = 0x26;
    sign[389] = 0x24;
    sign[390] = 0x09;
    sign[391] = 0xf7;
    sign[392] = 0x3c;
    sign[393] = 0xf8;
    sign[394] = 0x42;
    sign[395] = 0x5d;
    sign[396] = 0x25;
    sign[397] = 0xf0;
    sign[398] = 0x6a;
    sign[399] = 0xe4;
    sign[400] = 0x1e;
    sign[401] = 0xba;
    sign[402] = 0x29;
    sign[403] = 0x38;
    sign[404] = 0x64;
    sign[405] = 0x44;
    sign[406] = 0x16;
    sign[407] = 0xe1;
    sign[408] = 0x71;
    sign[409] = 0x8e;
    sign[410] = 0xf5;
    sign[411] = 0xbe;
    sign[412] = 0x3b;
    sign[413] = 0xd1;
    sign[414] = 0x1f;
    sign[415] = 0x5e;
    sign[416] = 0xe4;
    sign[417] = 0x29;
    sign[418] = 0xfb;
    sign[419] = 0x6d;
    sign[420] = 0x2b;
    sign[421] = 0x3a;
    sign[422] = 0xbe;
    sign[423] = 0xac;
    sign[424] = 0x00;
    sign[425] = 0xb0;
    sign[426] = 0x53;
    sign[427] = 0x49;
    sign[428] = 0xea;
    sign[429] = 0x02;
    sign[430] = 0x86;
    sign[431] = 0x9c;
    sign[432] = 0x01;
    sign[433] = 0xa7;
    sign[434] = 0xbf;
    sign[435] = 0x7e;
    sign[436] = 0x10;
    sign[437] = 0x18;
    sign[438] = 0x21;
    sign[439] = 0x6a;
    sign[440] = 0xa1;
    sign[441] = 0xb9;
    sign[442] = 0xf8;
    sign[443] = 0x7e;
    sign[444] = 0xb1;
    sign[445] = 0x97;
    sign[446] = 0x7e;
    sign[447] = 0x3a;
    sign[448] = 0xdc;
    sign[449] = 0xae;
    sign[450] = 0x42;
    sign[451] = 0xc3;
    sign[452] = 0x4c;
    sign[453] = 0xb8;
    sign[454] = 0xb5;
    sign[455] = 0x88;
    sign[456] = 0x0e;
    sign[457] = 0xb9;
    sign[458] = 0xf2;
    sign[459] = 0x5f;
    sign[460] = 0x51;
    sign[461] = 0x10;
    sign[462] = 0x4c;
    sign[463] = 0xaa;
    sign[464] = 0x20;
    sign[465] = 0x44;
    sign[466] = 0x51;
    sign[467] = 0x2d;
    sign[468] = 0xd3;
    sign[469] = 0xe7;
    sign[470] = 0xbc;
    sign[471] = 0x52;
    sign[472] = 0xc1;
    sign[473] = 0xae;
    sign[474] = 0x33;
    sign[475] = 0x45;
    sign[476] = 0x9f;
    sign[477] = 0x8e;
    sign[478] = 0x93;
    sign[479] = 0xce;
    sign[480] = 0xbb;
    sign[481] = 0x91;
    sign[482] = 0x55;
    sign[483] = 0xb4;
    sign[484] = 0x43;
    sign[485] = 0x87;
    sign[486] = 0x3d;
    sign[487] = 0x4b;
    sign[488] = 0x27;
    sign[489] = 0x1d;
    sign[490] = 0xbb;
    sign[491] = 0x23;
    sign[492] = 0xe2;
    sign[493] = 0xdb;
    sign[494] = 0xbb;
    sign[495] = 0x18;
    sign[496] = 0xdd;
    sign[497] = 0xaf;
    sign[498] = 0x27;
    sign[499] = 0xb0;
    sign[500] = 0x29;
    sign[501] = 0x2c;
    sign[502] = 0xc6;
    sign[503] = 0xe9;
    sign[504] = 0x1c;
    sign[505] = 0xcc;
    sign[506] = 0x21;
    sign[507] = 0x0f;
    sign[508] = 0xb9;
    sign[509] = 0x8a;
    sign[510] = 0xed;
    sign[511] = 0xc1;

    n[0] = 0xc6;
    n[1] = 0xff;
    n[2] = 0xd9;
    n[3] = 0x20;
    n[4] = 0xce;
    n[5] = 0x90;
    n[6] = 0xdd;
    n[7] = 0xe4;
    n[8] = 0x97;
    n[9] = 0x77;
    n[10] = 0x7e;
    n[11] = 0xa7;
    n[12] = 0x8a;
    n[13] = 0x65;
    n[14] = 0xef;
    n[15] = 0x21;
    n[16] = 0x92;
    n[17] = 0x94;
    n[18] = 0xb2;
    n[19] = 0x3e;
    n[20] = 0xd7;
    n[21] = 0xac;
    n[22] = 0x9f;
    n[23] = 0x86;
    n[24] = 0xb9;
    n[25] = 0x20;
    n[26] = 0x3b;
    n[27] = 0xa0;
    n[28] = 0x99;
    n[29] = 0x58;
    n[30] = 0xab;
    n[31] = 0xcc;
    n[32] = 0x70;
    n[33] = 0xe8;
    n[34] = 0x34;
    n[35] = 0x09;
    n[36] = 0x72;
    n[37] = 0x02;
    n[38] = 0xef;
    n[39] = 0xf5;
    n[40] = 0xeb;
    n[41] = 0xa2;
    n[42] = 0x1c;
    n[43] = 0x18;
    n[44] = 0xf4;
    n[45] = 0x6e;
    n[46] = 0xdb;
    n[47] = 0xc0;
    n[48] = 0xdb;
    n[49] = 0x6b;
    n[50] = 0x6a;
    n[51] = 0xf5;
    n[52] = 0x0c;
    n[53] = 0x8b;
    n[54] = 0x14;
    n[55] = 0xb6;
    n[56] = 0xdd;
    n[57] = 0x6a;
    n[58] = 0x89;
    n[59] = 0x4a;
    n[60] = 0x17;
    n[61] = 0x10;
    n[62] = 0x4f;
    n[63] = 0xb7;
    n[64] = 0x0a;
    n[65] = 0xe8;
    n[66] = 0x1d;
    n[67] = 0xd5;
    n[68] = 0x10;
    n[69] = 0x22;
    n[70] = 0x0b;
    n[71] = 0xb1;
    n[72] = 0x23;
    n[73] = 0x93;
    n[74] = 0xbc;
    n[75] = 0x8e;
    n[76] = 0x6d;
    n[77] = 0x34;
    n[78] = 0xac;
    n[79] = 0x80;
    n[80] = 0xdf;
    n[81] = 0x14;
    n[82] = 0xa3;
    n[83] = 0x42;
    n[84] = 0xac;
    n[85] = 0x2d;
    n[86] = 0x74;
    n[87] = 0xda;
    n[88] = 0x78;
    n[89] = 0x9c;
    n[90] = 0x45;
    n[91] = 0xdb;
    n[92] = 0x92;
    n[93] = 0x33;
    n[94] = 0x30;
    n[95] = 0xdd;
    n[96] = 0x6c;
    n[97] = 0xee;
    n[98] = 0x35;
    n[99] = 0xfa;
    n[100] = 0xd4;
    n[101] = 0xe1;
    n[102] = 0xc5;
    n[103] = 0xba;
    n[104] = 0x3a;
    n[105] = 0x3f;
    n[106] = 0xb7;
    n[107] = 0x0d;
    n[108] = 0xcb;
    n[109] = 0x03;
    n[110] = 0xb6;
    n[111] = 0x18;
    n[112] = 0x9c;
    n[113] = 0x87;
    n[114] = 0xdd;
    n[115] = 0xcd;
    n[116] = 0xde;
    n[117] = 0xba;
    n[118] = 0xf0;
    n[119] = 0x15;
    n[120] = 0x73;
    n[121] = 0x4b;
    n[122] = 0x26;
    n[123] = 0xa3;
    n[124] = 0x36;
    n[125] = 0x87;
    n[126] = 0xbe;
    n[127] = 0x5f;
    n[128] = 0x02;
    n[129] = 0xb6;
    n[130] = 0x14;
    n[131] = 0x04;
    n[132] = 0xb0;
    n[133] = 0xc4;
    n[134] = 0xb8;
    n[135] = 0x76;
    n[136] = 0xb3;
    n[137] = 0xd5;
    n[138] = 0xb5;
    n[139] = 0xbc;
    n[140] = 0x75;
    n[141] = 0xec;
    n[142] = 0x9f;
    n[143] = 0x4e;
    n[144] = 0xb3;
    n[145] = 0x0c;
    n[146] = 0x2a;
    n[147] = 0x2c;
    n[148] = 0x62;
    n[149] = 0x86;
    n[150] = 0xa4;
    n[151] = 0xe9;
    n[152] = 0xb6;
    n[153] = 0x89;
    n[154] = 0x2d;
    n[155] = 0xb2;
    n[156] = 0xd3;
    n[157] = 0xb3;
    n[158] = 0x18;
    n[159] = 0xa0;
    n[160] = 0x7c;
    n[161] = 0xc3;
    n[162] = 0x65;
    n[163] = 0x7c;
    n[164] = 0x7f;
    n[165] = 0x96;
    n[166] = 0x0e;
    n[167] = 0x93;
    n[168] = 0x92;
    n[169] = 0x5b;
    n[170] = 0x47;
    n[171] = 0xd7;
    n[172] = 0x62;
    n[173] = 0x7d;
    n[174] = 0x88;
    n[175] = 0x2e;
    n[176] = 0x7c;
    n[177] = 0x8d;
    n[178] = 0xf9;
    n[179] = 0x71;
    n[180] = 0x93;
    n[181] = 0x94;
    n[182] = 0x72;
    n[183] = 0xd2;
    n[184] = 0x28;
    n[185] = 0x6d;
    n[186] = 0xec;
    n[187] = 0x6b;
    n[188] = 0x38;
    n[189] = 0xc6;
    n[190] = 0xbb;
    n[191] = 0x8f;
    n[192] = 0xa7;
    n[193] = 0xa0;
    n[194] = 0x89;
    n[195] = 0x43;
    n[196] = 0x07;
    n[197] = 0xb2;
    n[198] = 0x41;
    n[199] = 0xe0;
    n[200] = 0xb4;
    n[201] = 0xe3;
    n[202] = 0xba;
    n[203] = 0x95;
    n[204] = 0xa6;
    n[205] = 0x1a;
    n[206] = 0x2e;
    n[207] = 0x69;
    n[208] = 0x2c;
    n[209] = 0x4f;
    n[210] = 0xee;
    n[211] = 0xfd;
    n[212] = 0x23;
    n[213] = 0x8f;
    n[214] = 0x7a;
    n[215] = 0x05;
    n[216] = 0x84;
    n[217] = 0xdc;
    n[218] = 0xd8;
    n[219] = 0xaa;
    n[220] = 0xb8;
    n[221] = 0x1f;
    n[222] = 0x2d;
    n[223] = 0x07;
    n[224] = 0x01;
    n[225] = 0xd1;
    n[226] = 0x8b;
    n[227] = 0x3a;
    n[228] = 0xb0;
    n[229] = 0x9f;
    n[230] = 0x92;
    n[231] = 0x95;
    n[232] = 0x69;
    n[233] = 0x5d;
    n[234] = 0x14;
    n[235] = 0x42;
    n[236] = 0xf7;
    n[237] = 0x72;
    n[238] = 0x3a;
    n[239] = 0x5a;
    n[240] = 0x3c;
    n[241] = 0x98;
    n[242] = 0x6b;
    n[243] = 0x05;
    n[244] = 0x38;
    n[245] = 0x7c;
    n[246] = 0xd3;
    n[247] = 0xd8;
    n[248] = 0xe1;
    n[249] = 0x60;
    n[250] = 0xc9;
    n[251] = 0x2a;
    n[252] = 0x22;
    n[253] = 0xf4;
    n[254] = 0xdb;
    n[255] = 0x09;
    n[256] = 0x40;
    n[257] = 0xe5;
    n[258] = 0xde;
    n[259] = 0x08;
    n[260] = 0x1b;
    n[261] = 0x09;
    n[262] = 0x28;
    n[263] = 0x1c;
    n[264] = 0xf7;
    n[265] = 0xeb;
    n[266] = 0x5e;
    n[267] = 0xfb;
    n[268] = 0x17;
    n[269] = 0x77;
    n[270] = 0x93;
    n[271] = 0x84;
    n[272] = 0x73;
    n[273] = 0x50;
    n[274] = 0xc7;
    n[275] = 0x5f;
    n[276] = 0x2d;
    n[277] = 0x59;
    n[278] = 0x74;
    n[279] = 0x11;
    n[280] = 0x31;
    n[281] = 0xf2;
    n[282] = 0x73;
    n[283] = 0xa8;
    n[284] = 0x49;
    n[285] = 0x2c;
    n[286] = 0x6c;
    n[287] = 0x47;
    n[288] = 0x74;
    n[289] = 0x76;
    n[290] = 0x4a;
    n[291] = 0x5c;
    n[292] = 0x6d;
    n[293] = 0xb2;
    n[294] = 0x5b;
    n[295] = 0xdf;
    n[296] = 0xde;
    n[297] = 0x7c;
    n[298] = 0xa0;
    n[299] = 0x61;
    n[300] = 0x85;
    n[301] = 0x01;
    n[302] = 0xa5;
    n[303] = 0x59;
    n[304] = 0xcb;
    n[305] = 0xcf;
    n[306] = 0x29;
    n[307] = 0xe4;
    n[308] = 0xdb;
    n[309] = 0x90;
    n[310] = 0x5c;
    n[311] = 0xb6;
    n[312] = 0x25;
    n[313] = 0x4a;
    n[314] = 0xde;
    n[315] = 0xdb;
    n[316] = 0x3e;
    n[317] = 0xef;
    n[318] = 0x63;
    n[319] = 0x92;
    n[320] = 0x12;
    n[321] = 0xad;
    n[322] = 0x07;
    n[323] = 0xfd;
    n[324] = 0xa1;
    n[325] = 0x57;
    n[326] = 0xc0;
    n[327] = 0x40;
    n[328] = 0x6f;
    n[329] = 0x5d;
    n[330] = 0x42;
    n[331] = 0x7b;
    n[332] = 0x47;
    n[333] = 0x64;
    n[334] = 0xc8;
    n[335] = 0x61;
    n[336] = 0xa5;
    n[337] = 0x6e;
    n[338] = 0x13;
    n[339] = 0xe0;
    n[340] = 0x1f;
    n[341] = 0xda;
    n[342] = 0x74;
    n[343] = 0x6e;
    n[344] = 0x4b;
    n[345] = 0x0d;
    n[346] = 0x32;
    n[347] = 0x51;
    n[348] = 0xdf;
    n[349] = 0xb7;
    n[350] = 0x73;
    n[351] = 0xe9;
    n[352] = 0x3e;
    n[353] = 0x64;
    n[354] = 0x72;
    n[355] = 0x83;
    n[356] = 0x09;
    n[357] = 0xbe;
    n[358] = 0xb5;
    n[359] = 0x01;
    n[360] = 0x8e;
    n[361] = 0x92;
    n[362] = 0xa7;
    n[363] = 0x27;
    n[364] = 0x98;
    n[365] = 0x39;
    n[366] = 0xb3;
    n[367] = 0xe7;
    n[368] = 0x0f;
    n[369] = 0x5b;
    n[370] = 0x9b;
    n[371] = 0xb9;
    n[372] = 0x0c;
    n[373] = 0x62;
    n[374] = 0x14;
    n[375] = 0x41;
    n[376] = 0x87;
    n[377] = 0x6b;
    n[378] = 0xa2;
    n[379] = 0xfb;
    n[380] = 0xd3;
    n[381] = 0xc1;
    n[382] = 0x6a;
    n[383] = 0x89;
    n[384] = 0x13;
    n[385] = 0x4d;
    n[386] = 0xc7;
    n[387] = 0x24;
    n[388] = 0x9d;
    n[389] = 0xf8;
    n[390] = 0x62;
    n[391] = 0x45;
    n[392] = 0x36;
    n[393] = 0xc2;
    n[394] = 0x63;
    n[395] = 0x7c;
    n[396] = 0x11;
    n[397] = 0xbd;
    n[398] = 0x57;
    n[399] = 0xfd;
    n[400] = 0xc4;
    n[401] = 0x00;
    n[402] = 0x15;
    n[403] = 0x8f;
    n[404] = 0x3b;
    n[405] = 0x51;
    n[406] = 0x5d;
    n[407] = 0xc2;
    n[408] = 0x55;
    n[409] = 0xe5;
    n[410] = 0xd2;
    n[411] = 0x7f;
    n[412] = 0x52;
    n[413] = 0xc7;
    n[414] = 0x49;
    n[415] = 0xed;
    n[416] = 0x29;
    n[417] = 0x1d;
    n[418] = 0xef;
    n[419] = 0xe4;
    n[420] = 0xe1;
    n[421] = 0xad;
    n[422] = 0x2e;
    n[423] = 0xc5;
    n[424] = 0x2b;
    n[425] = 0xba;
    n[426] = 0xfb;
    n[427] = 0xce;
    n[428] = 0x5a;
    n[429] = 0x13;
    n[430] = 0x7c;
    n[431] = 0x4b;
    n[432] = 0x30;
    n[433] = 0xd3;
    n[434] = 0x31;
    n[435] = 0xfa;
    n[436] = 0x9e;
    n[437] = 0x42;
    n[438] = 0x38;
    n[439] = 0x28;
    n[440] = 0xcc;
    n[441] = 0x82;
    n[442] = 0x38;
    n[443] = 0x17;
    n[444] = 0x7b;
    n[445] = 0x24;
    n[446] = 0x13;
    n[447] = 0xd6;
    n[448] = 0x20;
    n[449] = 0x23;
    n[450] = 0x39;
    n[451] = 0xa6;
    n[452] = 0xc5;
    n[453] = 0xab;
    n[454] = 0x77;
    n[455] = 0x2f;
    n[456] = 0x9b;
    n[457] = 0x0f;
    n[458] = 0x88;
    n[459] = 0x5c;
    n[460] = 0x63;
    n[461] = 0xbb;
    n[462] = 0x83;
    n[463] = 0x92;
    n[464] = 0xb0;
    n[465] = 0xf2;
    n[466] = 0xa0;
    n[467] = 0xe4;
    n[468] = 0xbb;
    n[469] = 0x5c;
    n[470] = 0x40;
    n[471] = 0x3b;
    n[472] = 0x12;
    n[473] = 0x58;
    n[474] = 0xe7;
    n[475] = 0x75;
    n[476] = 0x13;
    n[477] = 0x59;
    n[478] = 0x05;
    n[479] = 0x0b;
    n[480] = 0xe8;
    n[481] = 0xca;
    n[482] = 0x82;
    n[483] = 0xc4;
    n[484] = 0xdf;
    n[485] = 0x87;
    n[486] = 0x0e;
    n[487] = 0xda;
    n[488] = 0x0b;
    n[489] = 0xd2;
    n[490] = 0x3d;
    n[491] = 0xa8;
    n[492] = 0xc0;
    n[493] = 0xc7;
    n[494] = 0x6a;
    n[495] = 0x8e;
    n[496] = 0xcb;
    n[497] = 0x69;
    n[498] = 0xbf;
    n[499] = 0x73;
    n[500] = 0xa3;
    n[501] = 0xb7;
    n[502] = 0xfd;
    n[503] = 0xf7;
    n[504] = 0xe7;
    n[505] = 0x7f;
    n[506] = 0xac;
    n[507] = 0x7f;
    n[508] = 0xd3;
    n[509] = 0xe4;
    n[510] = 0x65;
    n[511] = 0x1d;

    err = IOSC_CreateObject( &pubh, IOSC_PUBLICKEY_TYPE, IOSC_RSA4096_SUBTYPE );

    ERROR_CHECK( err );

    err = IOSC_ImportPublicKey( n, eExt, pubh );

    ERROR_CHECK( err );
    PERF_START();

    err = IOSC_VerifyPublicKeySign( hash_data, 20, pubh, sign );

    PERF_END( "RSA Verify 4096 bit" );
    EXPECT_OK( err, "RSA Verify 4096 bit" );

    /* Negative test: change hash */
    hash_data[0] ^= 0x01;
    err = IOSC_VerifyPublicKeySign( hash_data, 20, pubh, sign );
    EXPECT_NOT_OK( err, "RSA Verify 4096 bit Negative Test: change hash" );

    /* Negative test: change sign */
    hash_data[0] ^= 0x01; /* restore the hash data */
    sign[10] ^= 0x01;
    err = IOSC_VerifyPublicKeySign( hash_data, 20, pubh, sign );
    EXPECT_NOT_OK( err, "RSA Verify 4096 bit Negative Test: change sign" );
    err = IOSC_DeleteObject( pubh );

    /* 2048 bit RSA test */
    hash_data[0] = 0xd2;
    hash_data[1] = 0x1f;
    hash_data[2] = 0x15;
    hash_data[3] = 0xc6;
    hash_data[4] = 0x83;
    hash_data[5] = 0x82;
    hash_data[6] = 0x93;
    hash_data[7] = 0xf8;
    hash_data[8] = 0xca;
    hash_data[9] = 0x5e;
    hash_data[10] = 0x14;
    hash_data[11] = 0x6e;
    hash_data[12] = 0x6e;
    hash_data[13] = 0x21;
    hash_data[14] = 0xad;
    hash_data[15] = 0x89;
    hash_data[16] = 0x99;
    hash_data[17] = 0x15;
    hash_data[18] = 0xc4;
    hash_data[19] = 0x00;

    sign[0] = 0x2e;
    sign[1] = 0x9f;
    sign[2] = 0xd6;
    sign[3] = 0x16;
    sign[4] = 0x53;
    sign[5] = 0xd2;
    sign[6] = 0x4b;
    sign[7] = 0xfa;
    sign[8] = 0xaf;
    sign[9] = 0xf2;
    sign[10] = 0x40;
    sign[11] = 0x6a;
    sign[12] = 0x85;
    sign[13] = 0x5a;
    sign[14] = 0xfd;
    sign[15] = 0x4b;
    sign[16] = 0x04;
    sign[17] = 0x5e;
    sign[18] = 0xa8;
    sign[19] = 0xe2;
    sign[20] = 0xcf;
    sign[21] = 0xf0;
    sign[22] = 0x7f;
    sign[23] = 0xd7;
    sign[24] = 0xbe;
    sign[25] = 0x60;
    sign[26] = 0x36;
    sign[27] = 0x09;
    sign[28] = 0xea;
    sign[29] = 0x0a;
    sign[30] = 0xd3;
    sign[31] = 0x43;
    sign[32] = 0x6b;
    sign[33] = 0xb3;
    sign[34] = 0x7b;
    sign[35] = 0xd5;
    sign[36] = 0xe4;
    sign[37] = 0x00;
    sign[38] = 0x01;
    sign[39] = 0x66;
    sign[40] = 0x1d;
    sign[41] = 0xde;
    sign[42] = 0xcf;
    sign[43] = 0xc6;
    sign[44] = 0x47;
    sign[45] = 0xac;
    sign[46] = 0x1d;
    sign[47] = 0x7e;
    sign[48] = 0x2b;
    sign[49] = 0xab;
    sign[50] = 0x1d;
    sign[51] = 0xee;
    sign[52] = 0xaa;
    sign[53] = 0x96;
    sign[54] = 0xf1;
    sign[55] = 0x6c;
    sign[56] = 0x91;
    sign[57] = 0xd3;
    sign[58] = 0x4b;
    sign[59] = 0x69;
    sign[60] = 0x5a;
    sign[61] = 0x00;
    sign[62] = 0x13;
    sign[63] = 0x9d;
    sign[64] = 0xf5;
    sign[65] = 0xfc;
    sign[66] = 0xa1;
    sign[67] = 0xe1;
    sign[68] = 0x7c;
    sign[69] = 0xf0;
    sign[70] = 0x11;
    sign[71] = 0xaa;
    sign[72] = 0x47;
    sign[73] = 0xca;
    sign[74] = 0xd0;
    sign[75] = 0x19;
    sign[76] = 0x25;
    sign[77] = 0x14;
    sign[78] = 0x62;
    sign[79] = 0x44;
    sign[80] = 0xc4;
    sign[81] = 0x0b;
    sign[82] = 0xf7;
    sign[83] = 0x51;
    sign[84] = 0x50;
    sign[85] = 0x2c;
    sign[86] = 0xf6;
    sign[87] = 0x5c;
    sign[88] = 0xc1;
    sign[89] = 0xc2;
    sign[90] = 0xf7;
    sign[91] = 0x81;
    sign[92] = 0x67;
    sign[93] = 0x53;
    sign[94] = 0xfd;
    sign[95] = 0x99;
    sign[96] = 0xf9;
    sign[97] = 0xd1;
    sign[98] = 0x30;
    sign[99] = 0xb9;
    sign[100] = 0xdb;
    sign[101] = 0x4a;
    sign[102] = 0xb0;
    sign[103] = 0x45;
    sign[104] = 0xc9;
    sign[105] = 0xc6;
    sign[106] = 0xac;
    sign[107] = 0xf6;
    sign[108] = 0xd5;
    sign[109] = 0xbe;
    sign[110] = 0x4a;
    sign[111] = 0x1f;
    sign[112] = 0x99;
    sign[113] = 0xa7;
    sign[114] = 0xda;
    sign[115] = 0xdb;
    sign[116] = 0x7b;
    sign[117] = 0xef;
    sign[118] = 0x4a;
    sign[119] = 0x9f;
    sign[120] = 0x38;
    sign[121] = 0x03;
    sign[122] = 0x79;
    sign[123] = 0xae;
    sign[124] = 0x81;
    sign[125] = 0x2f;
    sign[126] = 0x06;
    sign[127] = 0x84;
    sign[128] = 0xbf;
    sign[129] = 0x1d;
    sign[130] = 0x5e;
    sign[131] = 0x30;
    sign[132] = 0x45;
    sign[133] = 0xd6;
    sign[134] = 0x8e;
    sign[135] = 0xc6;
    sign[136] = 0xc4;
    sign[137] = 0xed;
    sign[138] = 0x04;
    sign[139] = 0xbd;
    sign[140] = 0xb6;
    sign[141] = 0xaa;
    sign[142] = 0x13;
    sign[143] = 0xc6;
    sign[144] = 0x8b;
    sign[145] = 0x87;
    sign[146] = 0xec;
    sign[147] = 0x53;
    sign[148] = 0x9c;
    sign[149] = 0xa8;
    sign[150] = 0x05;
    sign[151] = 0x4e;
    sign[152] = 0x19;
    sign[153] = 0xc2;
    sign[154] = 0xcd;
    sign[155] = 0x4b;
    sign[156] = 0x8f;
    sign[157] = 0xd8;
    sign[158] = 0xeb;
    sign[159] = 0x83;
    sign[160] = 0x73;
    sign[161] = 0xc6;
    sign[162] = 0xc6;
    sign[163] = 0x20;
    sign[164] = 0xe9;
    sign[165] = 0x75;
    sign[166] = 0x02;
    sign[167] = 0xdb;
    sign[168] = 0xdb;
    sign[169] = 0xf8;
    sign[170] = 0xd4;
    sign[171] = 0x8c;
    sign[172] = 0xa7;
    sign[173] = 0xa5;
    sign[174] = 0x8e;
    sign[175] = 0x42;
    sign[176] = 0x7e;
    sign[177] = 0x43;
    sign[178] = 0x19;
    sign[179] = 0x62;
    sign[180] = 0xd9;
    sign[181] = 0x92;
    sign[182] = 0x73;
    sign[183] = 0x73;
    sign[184] = 0xaa;
    sign[185] = 0x5e;
    sign[186] = 0x03;
    sign[187] = 0xcf;
    sign[188] = 0x68;
    sign[189] = 0x7d;
    sign[190] = 0x1a;
    sign[191] = 0xc5;
    sign[192] = 0xa6;
    sign[193] = 0x00;
    sign[194] = 0xfb;
    sign[195] = 0xfa;
    sign[196] = 0x6c;
    sign[197] = 0x4a;
    sign[198] = 0xee;
    sign[199] = 0x8b;
    sign[200] = 0xab;
    sign[201] = 0xd6;
    sign[202] = 0x32;
    sign[203] = 0x51;
    sign[204] = 0x6d;
    sign[205] = 0x58;
    sign[206] = 0xfa;
    sign[207] = 0x0b;
    sign[208] = 0x66;
    sign[209] = 0xa1;
    sign[210] = 0xc4;
    sign[211] = 0xd8;
    sign[212] = 0xc4;
    sign[213] = 0xec;
    sign[214] = 0x3d;
    sign[215] = 0x09;
    sign[216] = 0xd8;
    sign[217] = 0xf3;
    sign[218] = 0x30;
    sign[219] = 0x4f;
    sign[220] = 0xec;
    sign[221] = 0x37;
    sign[222] = 0xe4;
    sign[223] = 0x4e;
    sign[224] = 0x7f;
    sign[225] = 0x9a;
    sign[226] = 0xcb;
    sign[227] = 0x93;
    sign[228] = 0xfe;
    sign[229] = 0xa6;
    sign[230] = 0xec;
    sign[231] = 0x3f;
    sign[232] = 0xea;
    sign[233] = 0x6a;
    sign[234] = 0x27;
    sign[235] = 0x54;
    sign[236] = 0xa4;
    sign[237] = 0x04;
    sign[238] = 0xa4;
    sign[239] = 0x31;
    sign[240] = 0xb5;
    sign[241] = 0x4d;
    sign[242] = 0x16;
    sign[243] = 0x9c;
    sign[244] = 0x3e;
    sign[245] = 0x86;
    sign[246] = 0x54;
    sign[247] = 0x85;
    sign[248] = 0x2d;
    sign[249] = 0x0d;
    sign[250] = 0x2e;
    sign[251] = 0x1f;
    sign[252] = 0x6b;
    sign[253] = 0x4d;
    sign[254] = 0xd9;
    sign[255] = 0x1a;

    n[0] = 0xbb;
    n[1] = 0x2c;
    n[2] = 0x31;
    n[3] = 0xf7;
    n[4] = 0x2e;
    n[5] = 0xdf;
    n[6] = 0xd5;
    n[7] = 0x8e;
    n[8] = 0xcb;
    n[9] = 0xec;
    n[10] = 0xdf;
    n[11] = 0x9d;
    n[12] = 0xe7;
    n[13] = 0x34;
    n[14] = 0x24;
    n[15] = 0x50;
    n[16] = 0x8c;
    n[17] = 0x39;
    n[18] = 0xb1;
    n[19] = 0x12;
    n[20] = 0xf0;
    n[21] = 0x21;
    n[22] = 0x10;
    n[23] = 0xf2;
    n[24] = 0xf3;
    n[25] = 0xf0;
    n[26] = 0xe9;
    n[27] = 0x95;
    n[28] = 0x97;
    n[29] = 0x2b;
    n[30] = 0x2e;
    n[31] = 0xfc;
    n[32] = 0xe4;
    n[33] = 0x22;
    n[34] = 0x04;
    n[35] = 0x77;
    n[36] = 0x8b;
    n[37] = 0x0b;
    n[38] = 0xe7;
    n[39] = 0x4e;
    n[40] = 0xdc;
    n[41] = 0x2e;
    n[42] = 0xe0;
    n[43] = 0xc1;
    n[44] = 0x68;
    n[45] = 0xa9;
    n[46] = 0x0b;
    n[47] = 0x0f;
    n[48] = 0x1c;
    n[49] = 0x3a;
    n[50] = 0x5c;
    n[51] = 0x1a;
    n[52] = 0x66;
    n[53] = 0xf4;
    n[54] = 0xcf;
    n[55] = 0xfc;
    n[56] = 0x20;
    n[57] = 0x34;
    n[58] = 0xa9;
    n[59] = 0x6d;
    n[60] = 0xa6;
    n[61] = 0x04;
    n[62] = 0xda;
    n[63] = 0x5c;
    n[64] = 0x6c;
    n[65] = 0xd7;
    n[66] = 0x90;
    n[67] = 0x07;
    n[68] = 0xa5;
    n[69] = 0xb2;
    n[70] = 0xb1;
    n[71] = 0x20;
    n[72] = 0x4d;
    n[73] = 0xe8;
    n[74] = 0xf6;
    n[75] = 0x3d;
    n[76] = 0xb9;
    n[77] = 0xa8;
    n[78] = 0x98;
    n[79] = 0x89;
    n[80] = 0x74;
    n[81] = 0xc1;
    n[82] = 0x3d;
    n[83] = 0xf3;
    n[84] = 0xec;
    n[85] = 0x05;
    n[86] = 0xaf;
    n[87] = 0x64;
    n[88] = 0xf1;
    n[89] = 0x0a;
    n[90] = 0xfb;
    n[91] = 0xc9;
    n[92] = 0xa6;
    n[93] = 0xc8;
    n[94] = 0x37;
    n[95] = 0x4e;
    n[96] = 0x5d;
    n[97] = 0x81;
    n[98] = 0x04;
    n[99] = 0x13;
    n[100] = 0x92;
    n[101] = 0xdb;
    n[102] = 0xb5;
    n[103] = 0x51;
    n[104] = 0xcf;
    n[105] = 0x74;
    n[106] = 0x29;
    n[107] = 0xb7;
    n[108] = 0x06;
    n[109] = 0x45;
    n[110] = 0x0c;
    n[111] = 0x4a;
    n[112] = 0xb5;
    n[113] = 0xd7;
    n[114] = 0x04;
    n[115] = 0x1a;
    n[116] = 0xce;
    n[117] = 0xc2;
    n[118] = 0x63;
    n[119] = 0x6b;
    n[120] = 0xfc;
    n[121] = 0x61;
    n[122] = 0x53;
    n[123] = 0xf7;
    n[124] = 0x98;
    n[125] = 0xa4;
    n[126] = 0x05;
    n[127] = 0x44;
    n[128] = 0x20;
    n[129] = 0x62;
    n[130] = 0x58;
    n[131] = 0xc4;
    n[132] = 0x51;
    n[133] = 0x69;
    n[134] = 0x2c;
    n[135] = 0x6c;
    n[136] = 0x52;
    n[137] = 0x1d;
    n[138] = 0xf5;
    n[139] = 0x83;
    n[140] = 0xe4;
    n[141] = 0xcd;
    n[142] = 0x75;
    n[143] = 0x9a;
    n[144] = 0xb9;
    n[145] = 0x49;
    n[146] = 0xca;
    n[147] = 0xd4;
    n[148] = 0x4a;
    n[149] = 0xc7;
    n[150] = 0x42;
    n[151] = 0x6b;
    n[152] = 0xb4;
    n[153] = 0x22;
    n[154] = 0x8e;
    n[155] = 0xf4;
    n[156] = 0x62;
    n[157] = 0xa4;
    n[158] = 0xbf;
    n[159] = 0xac;
    n[160] = 0x05;
    n[161] = 0x64;
    n[162] = 0x6c;
    n[163] = 0x9f;
    n[164] = 0x83;
    n[165] = 0x0c;
    n[166] = 0xaf;
    n[167] = 0xf0;
    n[168] = 0x8e;
    n[169] = 0x25;
    n[170] = 0x19;
    n[171] = 0x20;
    n[172] = 0x34;
    n[173] = 0x23;
    n[174] = 0xc6;
    n[175] = 0x0f;
    n[176] = 0xa7;
    n[177] = 0x44;
    n[178] = 0xb1;
    n[179] = 0x20;
    n[180] = 0xae;
    n[181] = 0x63;
    n[182] = 0x43;
    n[183] = 0xd6;
    n[184] = 0xcd;
    n[185] = 0x2e;
    n[186] = 0xad;
    n[187] = 0x12;
    n[188] = 0x60;
    n[189] = 0xb6;
    n[190] = 0x95;
    n[191] = 0x6e;
    n[192] = 0xca;
    n[193] = 0xb2;
    n[194] = 0xd0;
    n[195] = 0x71;
    n[196] = 0x73;
    n[197] = 0x7f;
    n[198] = 0xcd;
    n[199] = 0x3b;
    n[200] = 0x7d;
    n[201] = 0xdb;
    n[202] = 0xa3;
    n[203] = 0xd0;
    n[204] = 0x16;
    n[205] = 0x9c;
    n[206] = 0xb3;
    n[207] = 0x89;
    n[208] = 0xfd;
    n[209] = 0x46;
    n[210] = 0x65;
    n[211] = 0x8d;
    n[212] = 0xe6;
    n[213] = 0x20;
    n[214] = 0x7a;
    n[215] = 0xe0;
    n[216] = 0x55;
    n[217] = 0xa1;
    n[218] = 0x1c;
    n[219] = 0xb0;
    n[220] = 0x33;
    n[221] = 0x10;
    n[222] = 0x55;
    n[223] = 0xc7;
    n[224] = 0x58;
    n[225] = 0x7d;
    n[226] = 0x94;
    n[227] = 0x9d;
    n[228] = 0x98;
    n[229] = 0xd5;
    n[230] = 0x7d;
    n[231] = 0x7a;
    n[232] = 0x57;
    n[233] = 0xa5;
    n[234] = 0x18;
    n[235] = 0x93;
    n[236] = 0x54;
    n[237] = 0x99;
    n[238] = 0x8e;
    n[239] = 0x81;
    n[240] = 0x6d;
    n[241] = 0x6f;
    n[242] = 0x3c;
    n[243] = 0x3b;
    n[244] = 0xca;
    n[245] = 0xff;
    n[246] = 0x27;
    n[247] = 0xed;
    n[248] = 0xfd;
    n[249] = 0x79;
    n[250] = 0xb4;
    n[251] = 0xd8;
    n[252] = 0x74;
    n[253] = 0xf5;
    n[254] = 0xb8;
    n[255] = 0x47;

    err = IOSC_CreateObject( &pubh, IOSC_PUBLICKEY_TYPE, IOSC_RSA2048_SUBTYPE );
    ERROR_CHECK( err );
    err = IOSC_ImportPublicKey( n, eExt, pubh );
    ERROR_CHECK( err );
    PERF_START();

    err = IOSC_VerifyPublicKeySign( hash_data, 20, pubh, sign );

    PERF_END( "RSA Verify 2048 bit" );
    EXPECT_OK( err, "RSA Verify 2048 bit" );

    /* Negative test: change hash */
    hash_data[0] ^= 0x01;
    err = IOSC_VerifyPublicKeySign( hash_data, 20, pubh, sign );
    EXPECT_NOT_OK( err, "RSA Verify 2048 bit Negative Test: change hash" );

    /* Negative test: change sign */
    hash_data[0] ^= 0x01; /* restore the hash */
    sign[10] ^= 0x01;
    err = IOSC_VerifyPublicKeySign( hash_data, 20, pubh, sign );
    EXPECT_NOT_OK( err, "RSA Verify 2048 bit Negative Test: change sign" );
    err = IOSC_DeleteObject( pubh );

#if defined( USE_BSAFE )
    /*
     * Verify using 1024 bit public key
     */
    verifyInitParam.key = static_cast<void *>( pub1024KeyModulus );
    verifyInitParam.key_len = sizeof( pub1024KeyModulus );

    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 1024 bit" );

    verifyParam.in = static_cast<void *>( input1024Data );
    verifyParam.in_len = sizeof( input1024Data );
    verifyParam.sign = static_cast<void *>( sign1024Data );
    verifyParam.sign_len = sizeof( sign1024Data );

    PERF_START();
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    PERF_END( "RSA_BSAFE_Verify 1024 bit" );
    EXPECT_OK( err, "RSA_BSAFE_Verify 1024 bit" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 1024 bit" );

    /*
     * Negative test:  modify the data
     */
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 1024 bit" );

    verifyParam.in = static_cast<void *>( input1024Data );
    verifyParam.in_len = sizeof( input1024Data );
    verifyParam.sign = static_cast<void *>( sign1024Data );
    verifyParam.sign_len = sizeof( sign1024Data );

    input1024Data[42] ^= 0x01;
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 1024 bit Negative Test: change input" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 1024 bit Negative Test: change input" );
    input1024Data[42] ^= 0x01;

    /*
     * Negative test:  modify the signature
     */
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 1024 bit" );

    verifyParam.in = static_cast<void *>( input1024Data );
    verifyParam.in_len = sizeof( input1024Data );
    verifyParam.sign = static_cast<void *>( sign1024Data );
    verifyParam.sign_len = sizeof( sign1024Data );

    sign1024Data[27] ^= 0x01;
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 1024 bit Negative Test: change signature" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 1024 bit Negative Test: change signature" );
    sign1024Data[27] ^= 0x01;

    /*
     * Negative test:  modify the pubkey
     */
    pub1024KeyModulus[32] ^= 0x01;
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 1024 bit" );

    verifyParam.in = static_cast<void *>( input1024Data );
    verifyParam.in_len = sizeof( input1024Data );
    verifyParam.sign = static_cast<void *>( sign1024Data );
    verifyParam.sign_len = sizeof( sign1024Data );

    verifyInitParam.key = static_cast<void *>( pub1024KeyModulus );
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 1024 bit Negative Test: change pubkey" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 1024 bit Negative Test: change pubkey" );
    pub1024KeyModulus[32] ^= 0x01;

    /*
     * Verify using 2048 bit public key
     */
    verifyInitParam.key = static_cast<void *>( pub2048KeyModulus );
    verifyInitParam.key_len = sizeof( pub2048KeyModulus );

    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 2048 bit" );

    verifyParam.in = static_cast<void *>( input2048Data );
    verifyParam.in_len = sizeof( input2048Data );
    verifyParam.sign = static_cast<void *>( sign2048Data );
    verifyParam.sign_len = sizeof( sign2048Data );

    PERF_START();
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    PERF_END( "RSA_BSAFE_Verify 2048 bit" );
    EXPECT_OK( err, "RSA_BSAFE_Verify 2048 bit" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 2048 bit" );

    /*
     * Negative test:  modify the data
     */
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 2048 bit" );

    verifyParam.in = static_cast<void *>( input2048Data );
    verifyParam.in_len = sizeof( input2048Data );
    verifyParam.sign = static_cast<void *>( sign2048Data );
    verifyParam.sign_len = sizeof( sign2048Data );

    input2048Data[42] ^= 0x01;
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 2048 bit Negative Test: change input" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 2048 bit Negative Test: change input" );
    input2048Data[42] ^= 0x01;

    /*
     * Negative test:  modify the signature
     */
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 2048 bit" );

    verifyParam.in = static_cast<void *>( input2048Data );
    verifyParam.in_len = sizeof( input2048Data );
    verifyParam.sign = static_cast<void *>( sign2048Data );
    verifyParam.sign_len = sizeof( sign2048Data );

    sign2048Data[27] ^= 0x01;
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 2048 bit Negative Test: change signature" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 2048 bit Negative Test: change signature" );
    sign2048Data[27] ^= 0x01;

    /*
     * Negative test:  modify the pubkey
     */
    pub2048KeyModulus[32] ^= 0x01;
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 2048 bit" );

    verifyParam.in = static_cast<void *>( input2048Data );
    verifyParam.in_len = sizeof( input2048Data );
    verifyParam.sign = static_cast<void *>( sign2048Data );
    verifyParam.sign_len = sizeof( sign2048Data );

    verifyInitParam.key = static_cast<void *>( pub2048KeyModulus );
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 2048 bit Negative Test: change pubkey" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 2048 bit Negative Test: change pubkey" );
    pub2048KeyModulus[32] ^= 0x01;

    /*
     * Verify using 4096 bit public key
     */
    verifyInitParam.key = static_cast<void *>( pub4096KeyModulus );
    verifyInitParam.key_len = sizeof( pub4096KeyModulus );

    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 4096 bit" );

    verifyParam.in = static_cast<void *>( input4096Data );
    verifyParam.in_len = sizeof( input4096Data );
    verifyParam.sign = static_cast<void *>( sign4096Data );
    verifyParam.sign_len = sizeof( sign4096Data );

    PERF_START();
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    PERF_END( "RSA_BSAFE_Verify 4096 bit" );
    EXPECT_OK( err, "RSA_BSAFE_Verify 4096 bit" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 4096 bit" );

    /*
     * Negative test:  modify the data
     */
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 4096 bit" );

    verifyParam.in = static_cast<void *>( input4096Data );
    verifyParam.in_len = sizeof( input4096Data );
    verifyParam.sign = static_cast<void *>( sign4096Data );
    verifyParam.sign_len = sizeof( sign4096Data );

    input4096Data[42] ^= 0x01;
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 4096 bit Negative Test: change input" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 4096 bit Negative Test: change input" );
    input4096Data[42] ^= 0x01;

    /*
     * Negative test:  modify the signature
     */
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 4096 bit" );

    verifyParam.in = static_cast<void *>( input4096Data );
    verifyParam.in_len = sizeof( input4096Data );
    verifyParam.sign = static_cast<void *>( sign4096Data );
    verifyParam.sign_len = sizeof( sign4096Data );

    sign4096Data[27] ^= 0x01;
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 4096 bit Negative Test: change signature" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 4096 bit Negative Test: change signature" );
    sign4096Data[27] ^= 0x01;

    /*
     * Negative test:  modify the pubkey
     */
    pub4096KeyModulus[32] ^= 0x01;
    err = CRYPTO_RSA_VerifyInit( &signContext, &verifyInitParam );
    EXPECT_OK( err, "RSA_BSAFE_VerifyInit 4096 bit" );

    verifyParam.in = static_cast<void *>( input4096Data );
    verifyParam.in_len = sizeof( input4096Data );
    verifyParam.sign = static_cast<void *>( sign4096Data );
    verifyParam.sign_len = sizeof( sign4096Data );

    verifyInitParam.key = static_cast<void *>( pub4096KeyModulus );
    err = CRYPTO_RSA_Verify( &signContext, &verifyParam );
    EXPECT_NOT_OK( err, "RSA_BSAFE_Verify 4096 bit Negative Test: change pubkey" );
    err = CRYPTO_RSA_VerifyTerminate( &signContext );
    EXPECT_OK( err, "RSA_BSAFE_VerifyTerminate 4096 bit Negative Test: change pubkey" );
    pub4096KeyModulus[32] ^= 0x01;

#endif /* USE_BSAFE */

    return 0;
}  // NOLINT (readability/fn_size)


#if defined( SEPARATE_MAIN_PROGRAM )

int main( int argc, char **argv )
{
    IOSC_Initialize();
    doRsaVerTest();
    EXIT( 0 );
    return 0;
}
#endif
