﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/err/err_ErrorInfo.h>

namespace nnt { namespace err {

void NnLogUtf16(const char16_t* utf16str) NN_NOEXCEPT;
bool CompareUtf8AndUtf16(const char* utf8str, const char16_t* utf16str) NN_NOEXCEPT;
void PrintUiSettings(const nn::err::ErrorInfo::UiSettings& uiSettings) NN_NOEXCEPT;
void PrintErrorInfo(const nn::err::ErrorInfo& info) NN_NOEXCEPT;
void PrintTimeOfOccurrence(const void* param) NN_NOEXCEPT;

}}
