﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testEns_TaskSimple.h"

namespace nnt { namespace ens {

/**
 * @brief   タスクを複数持って実行するタスク
 *
 * @details
 */
class TaskMultiple : public nn::ens::detail::core::Task
{
public:
    /**
     * @brief   サブタスク数です。
     *
     * @details
     */
    static const int SubTaskCount = 4;

public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskMultiple() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~TaskMultiple() NN_NOEXCEPT;

    /**
     * @brief   非同期コンテキストを登録解除します。
     *
     * @details
     */
    virtual void UnregisterAsyncContext() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   タスクをキャンセルします。
     *
     * @details
     *  別スレッド上で動いているタスクにキャンセル要求を通知します。
     */
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[out]  pOutCounter サブタスクの実行数
     * @param[in]   サブタスクに渡す待機期間
     *
     * @details
     */
    void SetParameter(int* pOutCounter, nn::TimeSpan span) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    int* m_pOutCounter;
    //
    nn::TimeSpan m_Span;
    //
    TaskSimple m_TaskSimples[SubTaskCount];
    nn::ens::AsyncContext m_Contexts[SubTaskCount];

private:
    //
    nn::Result StepDoSimple(int index) NN_NOEXCEPT;
};

}}
