﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/vi/vi_Display.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <Common/DisplayConfig.h>

namespace nns {

class ConfigSwitcher
{
private:
    static const int NpadIdCountMax = 3;
    const int m_ConfigNumber;

    bool m_IsVisible;
    bool m_IsFontColorDarkToLight;
    int m_PreTouchIndex;
    int m_SelectedIndex;
    int m_KeepingTouchCount;
    typedef struct
    {
        int select;
        int left;
        int right;
    } KeepingPressCount;
    KeepingPressCount m_DebugPadPressCount;
    KeepingPressCount m_BasicNpadPressCount;
    int m_LastTouchX;
    int m_LastTouchY;
    float m_ImageWidthRatio;
    float m_ImageHeightRatio;
    const uint8_t* m_Pixels;
    nn::hid::DebugPadState m_DebugPadState;
    nn::hid::NpadFullKeyState m_FullKeyState;
    nn::hid::NpadJoyDualState m_JoyDualState;
    nn::hid::NpadHandheldState m_HandheldState;
    nn::hid::NpadIdType m_NpadIds[NpadIdCountMax];
    nn::gfx::util::DebugFontTextWriter m_TextWriter;
    nn::util::BytePtr* m_pDebugFontHeap;
    nn::os::ThreadType m_ListenerThread;
    DisplayConfig* m_pDisplayConfig;
    nn::util::Unorm8x4 m_FontColor;
    nn::util::Unorm8x4 m_SelectedFontColor;
    Color m_BackGroundColor;

    void UpdateFontColor() NN_NOEXCEPT;
    void PutConfigList() NN_NOEXCEPT;
    int GetTouchedConfigIndex(const nn::hid::TouchState& state) NN_NOEXCEPT;
    void ChangeConfigViaTouchPanel() NN_NOEXCEPT;
    void ChangeConfigViaDebugPad() NN_NOEXCEPT;
    void ChangeConfigViaBasicNpad() NN_NOEXCEPT;

public:
    NN_IMPLICIT ConfigSwitcher(DisplayConfig* pConfig, bool isVisible) NN_NOEXCEPT;
    ~ConfigSwitcher() NN_NOEXCEPT;
    void Initialize(
        nn::gfx::Device* pDevice, const nn::vi::Display* pDisplay,
        nn::gfx::DescriptorPool* pTextureDescriptorPool,
        nn::gfx::DescriptorPool* pSamplerDescriptorPool,
        int textureDescriptorIndexSlot, int samplerDescriptorIndexSlot) NN_NOEXCEPT;
    void Initialize(nn::gfx::Device* pDevice, const nn::vi::Display* pDisplay) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Draw(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;
    void CreateInputListener() NN_NOEXCEPT;
    void DoListeningProcedure() NN_NOEXCEPT;
    bool IsSceneSwitchedOn() NN_NOEXCEPT;
    void ReferImagePixel(const uint8_t* pixels, int imageWidth, int imageHeight) NN_NOEXCEPT;
    const Color& GetBackGroundColorFromDisplayConfig();
};

}
