﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/vi/vi_Result.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include "master/detail/visrv_NullDisplay.h"
#include "testDisplay_MockFilter.h"

TEST(NullDisplay, Ctor_Any)
{
    nn::visrv::master::detail::NullDisplay display;

    nn::vi::LayerStackType stack;
    NNT_EXPECT_RESULT_SUCCESS(display.GetLayerStack(&stack));
    EXPECT_EQ(nn::vi::LayerStack_Null, stack);
}

TEST(NullDisplay, GetHotplugState_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::HotplugStateType state;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetHotplugState(&state));

    display.Close();
}

TEST(NullDisplay, ListModes_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::DisplayModeInfo modes[nn::vi::DisplayModeCountMax];
    EXPECT_EQ(0, display.ListModes(modes, nn::vi::DisplayModeCountMax));

    display.Close();
}

TEST(NullDisplay, GetMode_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::DisplayModeInfo mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultOperationFailed, display.GetMode(&mode));

    display.Close();
}

TEST(NullDisplay, SetMode_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::DisplayModeInfo mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetMode(mode));

    display.Close();
}

TEST(NullDisplay, ListRgbRanges_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::RgbRangeType ranges[nn::vi::RgbRange_Max];
    EXPECT_EQ(0, display.ListRgbRanges(ranges, nn::vi::RgbRange_Max));

    display.Close();
}

TEST(NullDisplay, GetRgbRange_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::RgbRangeType range;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultOperationFailed, display.GetRgbRange(&range));

    display.Close();
}

TEST(NullDisplay, SetRgbRange_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetRgbRange(nn::vi::RgbRange_Full));

    display.Close();
}

TEST(NullDisplay, SetUnderscan_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetUnderscan(0));

    display.Close();
}

TEST(NullDisplay, GetUnderscan_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    int underscan;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetUnderscan(&underscan));

    display.Close();
}

TEST(NullDisplay, SetAlpha_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetAlpha(1.f));

    display.Close();
}

TEST(NullDisplay, SetPowerState_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetPowerState(nn::vi::PowerState_On));

    display.Close();
}

TEST(NullDisplay, SetCmuLuma_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuLuma(0.f));

    display.Close();
}

TEST(NullDisplay, GetCmuLuma_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float luma;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetCmuLuma(&luma));

    display.Close();
}

TEST(NullDisplay, IsHotplugEventSupported_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    EXPECT_FALSE(display.IsHotplugEventSupported());

    display.Close();
}

TEST(NullDisplay, IsVsyncEventSupported_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    EXPECT_FALSE(display.IsVsyncEventSupported());

    display.Close();
}

TEST(NullDisplay, GetLogicalResolution_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    int width;
    int height;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetLogicalResolution(&width, &height));

    display.Close();
}

TEST(NullDisplay, SetLayerStack_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_SUCCESS(display.SetLayerStack(nn::vi::LayerStack_Null));

    display.Close();
}

TEST(NullDisplay, GetCmuMode_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::CmuModeType mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetCmuMode(&mode));

    display.Close();
}

TEST(NullDisplay, SetCmuMode_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_Disabled));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_Default));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_InvertColor));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_HighContrast));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_Grayscale));

    display.Close();
}

TEST(NullDisplay, GetContrastRatio_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float ratio;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetContrastRatio(&ratio));

    display.Close();
}

TEST(NullDisplay, SetContrastRatio_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetContrastRatio(0.f));

    display.Close();
}

TEST(NullDisplay, GetGamma_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float gamma;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetGamma(&gamma));

    display.Close();
}

TEST(NullDisplay, SetGamma_Any)
{
    nn::visrv::master::detail::NullDisplay display;
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetGamma(2.2f));

    display.Close();
}

TEST(NullDisplay, IsModeChangedEventSupported_Any)
{
    nn::visrv::master::detail::NullDisplay display;

    EXPECT_FALSE(display.IsModeChangedEventSupported());
}
