﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/vi/vi_DisplayModeInfoInternal.h>
#include "master/detail/visrv_IPhysicalDisplay.h"
#include "testDisplay_MockFilter.h"

class MockPhysicalDisplay : public nn::visrv::master::detail::IPhysicalDisplay
{
public:
    typedef std::vector<nn::vi::DisplayModeInfoInternal> ModeList;

    MockPhysicalDisplay() NN_NOEXCEPT;

    virtual nn::Result Open() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Close() NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetMode(nn::vi::DisplayModeInfo* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;

    virtual int ListModes(nn::vi::DisplayModeInfo* pOutModes, int modeCountMax) const NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result SetMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT NN_OVERRIDE;

    void SetHotplugState(nn::vi::HotplugStateType state) NN_NOEXCEPT;
    void SetAvailableModes(const ModeList& modes) NN_NOEXCEPT;

    void SetGetModeResult(const nn::Result& result) NN_NOEXCEPT;

    void SetValidRgbRanges(const nn::vi::RgbRange* pRanges, int rgbCountMax) NN_NOEXCEPT;
    virtual int ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetRgbRange(nn::vi::RgbRangeType* pOutRange) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT NN_OVERRIDE;
    float GetAlpha() const NN_NOEXCEPT;

    virtual nn::Result SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetPowerState(nn::vi::PowerStateType* pOutState) NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result SetLayerStack(nn::vi::LayerStackType id) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetLayerStack(nn::vi::LayerStackType* pOutStack) const NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result SetCmuLuma(float luma) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT NN_OVERRIDE;

    void SetIsHotplugEventSupported(bool isSupported) NN_NOEXCEPT;
    virtual bool IsHotplugEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

    void SetIsVsyncEventSupported(bool isSupported) NN_NOEXCEPT;
    virtual bool IsVsyncEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

    void SetIsModeChangedEventSupported(bool isSupported) NN_NOEXCEPT;
    virtual bool IsModeChangedEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

    void SetLogicalResolution(int width, int height) NN_NOEXCEPT;
    virtual nn::Result GetLogicalResolution(int* pOutWidth, int* pOutHeight) const NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result GetCmuMode(nn::vi::CmuModeType* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetContrastRatio(float* pOutRatio) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetContrastRatio(float ratio) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetGamma(float* pOutGamma) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetGamma(float gamma) NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result SetViewport(int x, int y, int width, int height) NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result GetCompositorErrorInfo(nn::vi::CompositorError* pOutErrorInfo, int* pOutLength, int errorID) NN_NOEXCEPT NN_OVERRIDE;

    MockFilter& GetFilter() NN_NOEXCEPT;

    static const int DisplayLogicalWidth;
    static const int DisplayLogicalHeight;
private:
    nn::vi::HotplugStateType m_State;
    nn::vi::DisplayModeInfo m_CurrentMode;
    ModeList m_AvailableModes;
    nn::Result m_GetModeResult;
    int m_Underscan;
    float m_Luma;
    nn::vi::PowerStateType m_Power;
    nn::vi::CmuMode m_CmuMode;
    float m_Contrast;

    nn::vi::RgbRange m_ValidRgbRanges[nn::vi::RgbRange_Max];
    int m_ValidRgbRangesSize;
    nn::vi::RgbRange m_CurrentRgb;

    float m_Alpha;
    float m_Gamma;

    nn::vi::LayerStackType m_LayerStack;

    bool m_IsVsyncEventSupported;
    bool m_IsHotplugEventSupported;
    bool m_IsModeChangedEventSupported;

    int m_LogicalWidth;
    int m_LogicalHeight;

    MockFilter m_Filter;
};
