﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testDisplay_MockFilter.h"

MockFilter::MockFilter() NN_NOEXCEPT
    : m_IsFilterUsed(false)
    , m_IsValid(true)
{
}

bool MockFilter::IsFilterUsed() const NN_NOEXCEPT
{
    return m_IsFilterUsed;
}

bool MockFilter::IsValid(const nn::vi::DisplayModeInfoInternal& mode) const NN_NOEXCEPT
{
    m_IsFilterUsed = true;

    return m_IsValid;
}

void MockFilter::SetFilterResult(bool isValid) NN_NOEXCEPT
{
    m_IsValid = isValid;
}

void MockFilter::Reset() NN_NOEXCEPT
{
    m_IsFilterUsed = false;
}
