﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include "master/detail/visrv_DefaultDisplay-spec.NX.h"
#include "master/detail/visrv_PlatformDisplayInfoSet.h"
#include "master/detail/visrv_DefaultDisplayStrategy.h"
#include "testDisplay_MockFilter.h"
#include "testDisplay_MockPhysicalDisplay.h"

class LayerFixture : public ::testing::Test
{
public:
    LayerFixture() NN_NOEXCEPT;
    virtual ~LayerFixture() NN_NOEXCEPT;

    nn::visrv::master::Display* GetDisplay() NN_NOEXCEPT;
    static void SetScalingModeSupport(bool isSupported) NN_NOEXCEPT;
    static bool IsScalingModeSupported(nn::vi::ScalingMode mode) NN_NOEXCEPT;
private:
    nn::visrv::master::detail::DefaultDisplay m_Display;
    nn::visrv::master::Display::Allocator m_Allocator;
    // need extra padding for memory manager
    char NN_ALIGNAS(NN_ALIGNOF(nn::visrv::master::Layer)) m_LayerSegment[sizeof(nn::visrv::master::Layer) * 2];

    static bool g_IsScalingModeSupported;

    MockPhysicalDisplay m_Lcd;
    MockPhysicalDisplay m_Hdmi;

    nn::visrv::master::detail::DefaultDisplayStrategy m_Strategy;

    MockFilter m_Filter;

    nn::visrv::master::detail::IPhysicalDisplay* m_Displays[2];
};
