﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include "settings/visrv_Settings.h"
#include "settings/visrv_PlatformConfig.h"
#include "settings/visrv_Strategy.h"
#include "settings/visrv_InterfaceType.h"

TEST(Settings, Icosa)
{
    nn::visrv::settings::Initialize();
    auto config = nn::visrv::settings::GetPlatformConfig();

    EXPECT_EQ(nn::visrv::settings::Strategy::PriorityFallback, config->defaultDisplayStrategy);
    NN_STATIC_ASSERT(sizeof(config->dcList) / sizeof(config->dcList[0]) == 2);
    EXPECT_EQ(0, config->dcList[0].priority);
    EXPECT_EQ(1, config->dcList[1].priority);

    ASSERT_EQ(2, config->physicalDisplayCount);
    EXPECT_STREQ("External", config->displays[0].name);
    EXPECT_EQ(1, config->displays[0].dc);
    EXPECT_STREQ("Edid", config->displays[0].edidDisplayName);

    EXPECT_EQ(nn::visrv::settings::InterfaceType::DisplayPort, config->dcList[1].interface);
    ASSERT_EQ(3, config->dcList[1].modeCount);
    EXPECT_EQ(1920, config->dcList[1].modes[0].clientInfo.width);
    EXPECT_EQ(1080, config->dcList[1].modes[0].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[1].modes[0].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[1].modes[0].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[1].modes[0].ratio);

    EXPECT_EQ(1280, config->dcList[1].modes[1].clientInfo.width);
    EXPECT_EQ(720, config->dcList[1].modes[1].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[1].modes[1].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[1].modes[1].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[1].modes[1].ratio);

    EXPECT_EQ(720, config->dcList[1].modes[2].clientInfo.width);
    EXPECT_EQ(480, config->dcList[1].modes[2].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[1].modes[2].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[1].modes[2].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[1].modes[2].ratio);

    EXPECT_STREQ("Internal", config->displays[1].name);
    EXPECT_EQ(0, config->displays[1].dc);
    EXPECT_STREQ("", config->displays[1].edidDisplayName);

    EXPECT_EQ(nn::visrv::settings::InterfaceType::Dsi, config->dcList[0].interface);
    ASSERT_EQ(1, config->dcList[0].modeCount);
    EXPECT_EQ(1280, config->dcList[0].modes[0].clientInfo.width);
    EXPECT_EQ(720, config->dcList[0].modes[0].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[0].modes[0].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[0].modes[0].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[0].modes[0].ratio);

    nn::visrv::settings::Finalize();
}

TEST(Settings, Copper)
{
    nn::visrv::settings::Initialize();
    auto config = nn::visrv::settings::GetPlatformConfig();

    EXPECT_EQ(nn::visrv::settings::Strategy::HighestPriority, config->defaultDisplayStrategy);
    NN_STATIC_ASSERT(sizeof(config->dcList) / sizeof(config->dcList[0]) == 2);
    EXPECT_EQ(-1, config->dcList[0].priority);
    EXPECT_EQ(1, config->dcList[1].priority);

    ASSERT_EQ(1, config->physicalDisplayCount);
    EXPECT_STREQ("External", config->displays[0].name);
    EXPECT_EQ(1, config->displays[0].dc);
    EXPECT_STREQ("Edid", config->displays[0].edidDisplayName);

    EXPECT_EQ(nn::visrv::settings::InterfaceType::Hdmi, config->dcList[1].interface);
    ASSERT_EQ(3, config->dcList[1].modeCount);
    EXPECT_EQ(1920, config->dcList[1].modes[0].clientInfo.width);
    EXPECT_EQ(1080, config->dcList[1].modes[0].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[1].modes[0].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[1].modes[0].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[1].modes[0].ratio);

    EXPECT_EQ(1280, config->dcList[1].modes[1].clientInfo.width);
    EXPECT_EQ(720, config->dcList[1].modes[1].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[1].modes[1].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[1].modes[1].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[1].modes[1].ratio);

    EXPECT_EQ(720, config->dcList[1].modes[2].clientInfo.width);
    EXPECT_EQ(480, config->dcList[1].modes[2].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[1].modes[2].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[1].modes[2].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[1].modes[2].ratio);

    EXPECT_EQ(nn::visrv::settings::InterfaceType::Null, config->dcList[0].interface);

    nn::visrv::settings::Finalize();
}

TEST(Settings, Hoag)
{
    nn::visrv::settings::Initialize();
    auto config = nn::visrv::settings::GetPlatformConfig();

    EXPECT_EQ(nn::visrv::settings::Strategy::HighestPriority, config->defaultDisplayStrategy);
    NN_STATIC_ASSERT(sizeof(config->dcList) / sizeof(config->dcList[0]) == 2);
    EXPECT_EQ(1, config->dcList[0].priority);
    EXPECT_EQ(-1, config->dcList[1].priority);

    ASSERT_EQ(1, config->physicalDisplayCount);
    EXPECT_STREQ("Internal", config->displays[0].name);
    EXPECT_EQ(0, config->displays[0].dc);
    EXPECT_STREQ("", config->displays[0].edidDisplayName);

    ASSERT_EQ(1, config->dcList[0].modeCount);
    EXPECT_EQ(1280, config->dcList[0].modes[0].clientInfo.width);
    EXPECT_EQ(720, config->dcList[0].modes[0].clientInfo.height);
    EXPECT_EQ(60.f, config->dcList[0].modes[0].clientInfo.refreshRate);
    EXPECT_EQ(nn::vi::StereoMode_None, config->dcList[0].modes[0].clientInfo.mode);
    EXPECT_EQ(nn::vi::AspectRatio_16_9, config->dcList[0].modes[0].ratio);

    ASSERT_EQ(0, config->dcList[1].modeCount);

    EXPECT_EQ(nn::visrv::settings::InterfaceType::Null, config->dcList[1].interface);

    nn::visrv::settings::Finalize();
}
