﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/os.h>
#include <nn/init.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>

const size_t HeapSize  = 512 * 1024 * 1024;
const size_t BlockSize = 128 * 1024 * 1024;

static void* Allocate(size_t size)
{
    return malloc(size);
}

static void Free(void* ptr, size_t size)
{
    NN_UNUSED(size);
    free(ptr);
}

extern "C" void nninitStartup()
{
    NN_ASSERT(nn::os::SetMemoryHeapSize(HeapSize).IsSuccess(), "SetMemoryHeapSize failed.\n");

    uintptr_t address;
    nn::Result result = nn::os::AllocateMemoryBlock(&address, BlockSize);
    NN_ASSERT(result.IsSuccess());
    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), BlockSize);

    nn::fs::SetAllocator(Allocate, Free);
}
