﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// Automated testing for CEC (no TV)

#include <cstdio>
#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Log.h>
#include <nn/settings/system/settings_Tv.h>
#include <nn/result/result_HandlingUtility.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nntest.h>

#include <nn/cec/cec_Api.h>

#include "Helper.h"

class CecTest : public testing::Test
{
protected:
    virtual void SetUp()
    {
        bool isStarted;
        NNT_ASSERT_RESULT_SUCCESS(nn::cec::IsStarted(&isStarted));

        SuspendCECManager(isStarted);
    }

    virtual void TearDown()
    {
    }

    static void SetUpTestCase()
    {
        nn::cec::Initialize(&s_CecSystemEvent);
    }

    static void TearDownTestCase()
    {
        nn::cec::Finalize(&s_CecSystemEvent);
    }
};

//**************************************************
// Sandbox testing
//**************************************************
TEST_F(CecTest, Sandbox)
{
    ResumeCECManager(false);

    for (int i = 0; i < 100000; ++i)
    {
        NN_LOG("Iteration %i\n", i);

        TurnOnTV();

        TurnOffTV();
    }
}

//**************************************************
// Cancels during each function that supports cancelling
//**************************************************
TEST_F(CecTest, Cancel)
{
    CallAndCancelFunction(CallCancelledRestartManager, 1000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 2000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 5000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 10000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 20000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 50000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 100000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 150000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 200000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 250000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 300000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 400000, 1100);
    CallAndCancelFunction(CallCancelledRestartManager, 500000, 1100);

    bool isStarted;
    NNT_ASSERT_RESULT_SUCCESS(nn::cec::IsStarted(&isStarted));

    ResumeCECManager(isStarted);

    CallAndCancelFunction(CallCancelledIsTvResponsive, 1000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 2000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 5000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 10000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 20000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 50000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 100000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 150000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 200000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 250000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 300000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 400000, 1100);
    CallAndCancelFunction(CallCancelledIsTvResponsive, 500000, 1100);

    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 1000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 2000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 5000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 10000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 20000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 50000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 100000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 150000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 200000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 250000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 300000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 400000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 500000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 600000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 800000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 1000000, 1100);
    CallAndCancelFunction(CallCancelledPerformOneTouchPlay, 1500000, 1100);

    TurnOnTV();

    CallAndCancelFunction(CallCancelledGetTvPowerState, 1000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 2000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 5000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 10000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 20000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 50000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 100000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 150000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 200000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 250000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 300000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 400000, 1100);
    CallAndCancelFunction(CallCancelledGetTvPowerState, 500000, 1100);
}

//**************************************************
// A simple CEC test to make sure basic functionality works
//**************************************************
TEST_F(CecTest, Simple)
{
    SuspendCECManager(false);

    // fails due to SIGLO-50341
    bool isTvResponsive = false;
    //NNT_EXPECT_RESULT_SUCCESS(nn::cec::IsTvResponsive(&isTvResponsive));
    //EXPECT_TRUE(isTvResponsive);

    ResumeCECManager(false);

    isTvResponsive = false;
    NNT_EXPECT_RESULT_SUCCESS(nn::cec::IsTvResponsive(&isTvResponsive));
    EXPECT_TRUE(isTvResponsive);

    // Wait for the TV to either be on or off
    nn::cec::PowerState powerState = GetPowerState(s_PowerStateTimeoutMs);
    if (powerState == nn::cec::PowerState_GoingOn)
    {
        WaitForPowerState(nn::cec::PowerState_On, s_PowerStateTimeoutMs, true);
    }
    else if (powerState == nn::cec::PowerState_GoingStandby)
    {
        WaitForPowerState(nn::cec::PowerState_Standby, s_PowerStateTimeoutMs, true);
    }

    // For the test, make sure the TV is off
    if (powerState == nn::cec::PowerState_On)
    {
        TurnOffTV();
    }

    TurnOnTV();

    TurnOffTV();

    SuspendCECManager(true);
}
