﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Tv.h>
#include <nvnflinger_service.h>
#include <nvdc.h>
#include <hos/nvdcutil.h>

namespace nns {

class VideoConfigUtility
{
private:
    NN_IMPLICIT VideoConfigUtility() NN_NOEXCEPT;
    ~VideoConfigUtility() NN_NOEXCEPT;

    android::sp<android::IBinder> m_Video;
    android::sp<android::SurfaceComposerClient> m_Client;
    nvdcHandle m_NvdcHandle;
    nvdcutilHandle m_NvdcUtilHandle;

public:
    static VideoConfigUtility& GetInstance()
    {
        static VideoConfigUtility instance;
        return instance;
    }

    bool ShowDisplayInfo() NN_NOEXCEPT;
    bool SetActiveDisplay(int id) NN_NOEXCEPT;
    int GetActiveDisplayId() NN_NOEXCEPT;
    android::DisplayInfo GetDisplayInfo(int id) NN_NOEXCEPT;
    int GetDisplayInfoCount() NN_NOEXCEPT;
    bool SetVirtualEdid(const char* edidPath) NN_NOEXCEPT;
    bool ResetVirtualEdid() NN_NOEXCEPT;
};

}
