﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <queue>
#include <memory>
#include <vector>

struct WorkerThreading
{
    explicit WorkerThreading(int threads = 8);
    ~WorkerThreading();

    void SetThreadCount(int threads);

    typedef void (*CallFunc)(void*);

    void RunFunction(CallFunc func, void* pData);

private:

    struct QueueData
    {
        QueueData(CallFunc _func = nullptr, void* _pData = nullptr)
            : func(_func), pData(_pData) {}

        CallFunc func;
        void* pData;
    };

    std::mutex m_mutex;
    std::queue<QueueData> m_queue;

    std::vector<std::thread> m_threads;
    int m_threadCount;

    bool m_quit;

    friend void WorkerThreadFunc(WorkerThreading* parent);
};
