﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;

namespace TargetUtility
{
    static class EnumerableExtensions
    {
        public static void Invoke<T>(this IEnumerable<T> enumerable, Action<T> action, int concurrencyCount = 0)
        {
            if (!enumerable.Any())
            {
                return;
            }

            var concurrencyCountMax = concurrencyCount > 0 ? concurrencyCount : enumerable.Count();

            var exceptionList = new List<Exception>();

            using (var countdownEvent = new CountdownEvent(enumerable.Count()))
            using (var semaphore = new SemaphoreSlim(concurrencyCountMax))
            {
                var wc = new WaitCallback(state =>
                {
                    try
                    {
                        action((T)state);
                    }
                    catch (Exception e)
                    {
                        lock (exceptionList) exceptionList.Add(e);
                    }
                    semaphore.Release();
                    countdownEvent.Signal();
                });

                foreach (var item in enumerable.Skip(1))
                {
                    semaphore.Wait();
                    ThreadPool.QueueUserWorkItem(wc, item);
                }

                semaphore.Wait();
                wc.Invoke(enumerable.First());

                countdownEvent.Wait();
            }

            if (exceptionList.Any())
            {
                throw new AggregateException(exceptionList.ToArray());
            }
        }
    }
}
