﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <stack>
#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/diag.h>

extern "C" void GiantFunction()
{
}

extern "C" void TinyFunction()
{
}

extern "C" void UsefulFunction()
{
}

extern "C" void UselessFunction()
{
}

TEST(SymbolTest, GetSymbolName)
{
    static char s_NameBuffer[128];
    uintptr_t symbolAddress;

    symbolAddress = nn::diag::GetSymbolName(s_NameBuffer, sizeof(s_NameBuffer), reinterpret_cast<uintptr_t>(GiantFunction));
    EXPECT_EQ(symbolAddress, reinterpret_cast<uintptr_t>(GiantFunction));
    EXPECT_STREQ(s_NameBuffer, "GiantFunction");

    symbolAddress = nn::diag::GetSymbolName(s_NameBuffer, sizeof(s_NameBuffer), reinterpret_cast<uintptr_t>(TinyFunction));
    EXPECT_EQ(symbolAddress, reinterpret_cast<uintptr_t>(TinyFunction));
    EXPECT_STREQ(s_NameBuffer, "TinyFunction");

    symbolAddress = nn::diag::GetSymbolName(s_NameBuffer, sizeof(s_NameBuffer), reinterpret_cast<uintptr_t>(UsefulFunction));
    EXPECT_EQ(symbolAddress, reinterpret_cast<uintptr_t>(UsefulFunction));
    EXPECT_STREQ(s_NameBuffer, "UsefulFunction");

    symbolAddress = nn::diag::GetSymbolName(s_NameBuffer, sizeof(s_NameBuffer), reinterpret_cast<uintptr_t>(UselessFunction));
    EXPECT_EQ(symbolAddress, reinterpret_cast<uintptr_t>(UselessFunction));
    EXPECT_STREQ(s_NameBuffer, "UselessFunction");
}

TEST(GetSymbolSizeTest, Basic)
{
    size_t symbolSize;

    symbolSize = nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(GiantFunction));
    EXPECT_GT(symbolSize, 0u);
    NN_LOG("GiantFunction (address=%P, size=%d)\n", reinterpret_cast<uintptr_t>(GiantFunction), symbolSize);

    symbolSize = nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(TinyFunction));
    EXPECT_GT(symbolSize, 0u);
    NN_LOG("TinyFunction (address=%P, size=%d)\n", reinterpret_cast<uintptr_t>(TinyFunction), symbolSize);

    symbolSize = nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(UsefulFunction));
    EXPECT_GT(symbolSize, 0u);
    NN_LOG("UsefulFunction (address=%P, size=%d)\n", reinterpret_cast<uintptr_t>(UsefulFunction), symbolSize);

    symbolSize = nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(UselessFunction));
    EXPECT_GT(symbolSize, 0u);
    NN_LOG("UselessFunction (address=%P, size=%d)\n", reinterpret_cast<uintptr_t>(UselessFunction), symbolSize);
}

TEST(GetSymbolSizeTest, NotFound)
{
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::SetAssertionFailureHandler) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::RegisterLogObserver) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::UnregisterLogObserver) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::InitializeLogObserverHolder) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::detail::UnexpectedDefaultImpl) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::RegisterAbortObserver) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::UnregisterAbortObserver) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::EnableDefaultAbortObserver) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::InitializeAbortObserverHolder) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::IsDebuggerAttached) + 1));
#if defined (NN_BUILD_CONFIG_OS_HORIZON)
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetModulePath) + 1));
#endif
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetSymbolName) + 1));
    EXPECT_EQ(0u, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetSymbolSize) + 1));
}

#if 0 // シンボルサイズは実装およびツールチェインの変更で変動するため、無効化しておく。
#if defined (NN_BUILD_CONFIG_OS_HORIZON) && defined (NN_SDK_BUILD_DEVELOP)

TEST(GetSymbolSizeTest, GetSize)
{
#if defined (NN_BUILD_CONFIG_ADDRESS_32)
    EXPECT_EQ(0x00000010, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::SetAssertionFailureHandler)));
    EXPECT_EQ(0x000000b0, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::RegisterLogObserver)));
    EXPECT_EQ(0x000000b8, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::UnregisterLogObserver)));
    EXPECT_EQ(0x00000018, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::InitializeLogObserverHolder)));
    EXPECT_EQ(0x000000a4, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::RegisterAbortObserver)));
    EXPECT_EQ(0x000000e4, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::UnregisterAbortObserver)));
    EXPECT_EQ(0x00000014, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::EnableDefaultAbortObserver)));
    EXPECT_EQ(0x00000010, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::InitializeAbortObserverHolder)));
    EXPECT_EQ(0x000000c0, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::IsDebuggerAttached)));
    EXPECT_EQ(0x00000168, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetModulePath)));
    EXPECT_EQ(0x00000168, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetSymbolName)));
    EXPECT_EQ(0x0000008c, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetSymbolSize)));
#elif defined (NN_BUILD_CONFIG_ADDRESS_64)
    EXPECT_EQ(0x000000000000000c, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::SetAssertionFailureHandler)));
    EXPECT_EQ(0x0000000000000084, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::RegisterLogObserver)));
    EXPECT_EQ(0x0000000000000090, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::UnregisterLogObserver)));
    EXPECT_EQ(0x0000000000000010, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::InitializeLogObserverHolder)));
    EXPECT_EQ(0x0000000000000050, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::detail::UnexpectedDefaultImpl)));
    EXPECT_EQ(0x000000000000008c, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::RegisterAbortObserver)));
    EXPECT_EQ(0x00000000000000d0, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::UnregisterAbortObserver)));
    EXPECT_EQ(0x0000000000000014, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::EnableDefaultAbortObserver)));
    EXPECT_EQ(0x000000000000000c, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::InitializeAbortObserverHolder)));
    EXPECT_EQ(0x000000000000009c, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::IsDebuggerAttached)));
    EXPECT_EQ(0x00000000000000f4, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetModulePath)));
    EXPECT_EQ(0x00000000000000f4, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetSymbolName)));
    EXPECT_EQ(0x0000000000000060, nn::diag::GetSymbolSize(reinterpret_cast<uintptr_t>(nn::diag::GetSymbolSize)));
#endif
}

#endif // #if defined (NN_BUILD_CONFIG_OS_HORIZON) && defined (NN_BUILD_CONFIG_ADDRESS_64)
#endif
