﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"

#include <cstring>
#include <cstdarg>

#include <nn/dd/dd_Config.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_FormatString.h>

#include <nn/dd.h>

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>
#include <nnt/nnt_Argument.h>

extern "C" void nntosTestTypeInfoDumpForC(void);

extern "C" bool nntddCacheTestForC(void);
extern "C" bool nntddPhysicalAddressTestForC(void);
extern "C" bool nntddIoMappingAddressTestForC(void);
extern "C" bool nntddMemoryBarrierTestForC(void);


namespace nnt { namespace dd {

TEST(LinkageC, TypeInfoDump)
{
    NN_LOG("\n");
    NN_LOG("C++: PhysicalMemoryInfo: size=%d align=%d\n", sizeof(nn::dd::PhysicalMemoryInfo), NN_ALIGNOF(nn::dd::PhysicalMemoryInfo));
    NN_LOG("\n");

    nntosTestTypeInfoDumpForC();
}

//-----------------------------------------------------------------------------
//  C 言語 API の動作テスト
//-----------------------------------------------------------------------------

TEST(LinkageC_Cache, CacheApiTestForC)
{
    bool result = nntddCacheTestForC();
    result ? SUCCEED() : ADD_FAILURE();
}

TEST(LinkageC_PhysicalAddress, PhysicalAddressTestForC)
{
    bool result = nntddPhysicalAddressTestForC();
    result ? SUCCEED() : ADD_FAILURE();
}

TEST(LinkageC_IoMappingAddress, IoMappingAddressTestForC)
{
    bool result = nntddIoMappingAddressTestForC();
    result ? SUCCEED() : ADD_FAILURE();
}

TEST(LinkageC_MemoryBarrier, MemoryBarrierTestForC)
{
    bool result = nntddMemoryBarrierTestForC();
    result ? SUCCEED() : ADD_FAILURE();
}

//-----------------------------------------------------------------------------

extern "C" void nnMain()
{
    // コマンドライン引数を取得
    int    argc = nnt::GetHostArgc();
    char** argv = nnt::GetHostArgv();

    NN_LOG("TEST: argc=%d\n", argc);
    NN_LOG("TEST: argv=0x%p\n", argv);

    // GoogleTest おまじない
    ::testing::InitGoogleTest(&argc, argv);

    // TeamCity の表示を適切にするため、イベントリスナの登録を一旦すべて解除し、
    // ServiceMessageLogger -> デフォルトのイベントリスナ の順で登録し直す。
    ::testing::TestEventListeners& listeners = ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter = listeners.Release(listeners.default_result_printer());
    listeners.Append(new nnt::teamcity::ServiceMessageLogger());
    listeners.Append(defaultResultPrinter);

    int result = RUN_ALL_TESTS();

    // 終了コードを設定
    nnt::Exit( result );
}

//-----------------------------------------------------------------------------

}}  // namespace nnt::dd
