﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nnc/nn_Common.h>
#include <nnc/dd.h>


//---------------------------------------------------------------------------
//  各ターゲットボードにおいて、nndd:QueryIoMappingAddress() テストの
//  対象とする I/O レジスタ領域の物理アドレスを定義。
//  本テストでは、実際に I/O レジスタ自身にアクセスするわけではなく、
//  仮想アドレスへの変換が出来るかどうかをテストする。

#if defined( NN_BUILD_CONFIG_HARDWARE_BDSLIMX6 )

// On Chip RAM 256KB をマッピング
const nnddPhysicalAddress TargetIoPhysicalAddress = 0x0000000000900000ull;
const size_t              TargetIoSize            = 0x00040000;

#elif defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) || \
      defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 )

// nVIDIA Timer (TMR)
const nnddPhysicalAddress TargetIoPhysicalAddress = 0x0000000060005000ull;
const size_t              TargetIoSize            = 0x00000400;

#elif defined( NN_BUILD_CONFIG_SOC_TEGRA_X1 )

// nVIDIA Timer (TMR)
const nnddPhysicalAddress TargetIoPhysicalAddress = 0x0000000060005000ull;
const size_t              TargetIoSize            = 0x00000400;

#elif defined( NN_BUILD_CONFIG_HARDWARE_JUNO )

// SP804 Dual Timer 0/1 をマッピング
const nnddPhysicalAddress TargetIoPhysicalAddress = 0x000000001c110000ull;
const size_t              TargetIoSize            = 0x00010000;

#elif defined( NN_BUILD_CONFIG_HARDWARE_SMMA53 )

// SP804 Dual Timer 0/1 をマッピング
const nnddPhysicalAddress TargetIoPhysicalAddress = 0x000000001c110000ull;
const size_t              TargetIoSize            = 0x00010000;

#else

const nnddPhysicalAddress TargetIoPhysicalAddress = 0x0000000000000000ull;
const size_t              TargetIoSize            = 0x00030000;

#endif

//---------------------------------------------------------------------------


