﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <sstream>
#include <iomanip>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nnt/nntest.h>

inline
::testing::AssertionResult CmpHelperARRAYEQ(const char* expr1,
                                            const char* expr2,
                                            const char* expr3,
                                            const void* actual,
                                            const void* expected,
                                            size_t size)
{
    if (std::memcmp(actual, expected, size) == 0)
    {
        return ::testing::AssertionSuccess();
    }
    else
    {
        std::stringstream ss1;
        ss1 << std::hex;
        for (int i = 0; i < static_cast<int>(size); i++)
        {
            ss1 << std::setw(2) << std::setfill('0') << (static_cast<const uint8_t*>(actual)[i] & 0xff);
        }

        std::stringstream ss2;
        ss2 << std::hex;
        for (int i = 0; i < static_cast<int>(size); i++)
        {
            ss2 << std::setw(2) << std::setfill('0') << (static_cast<const uint8_t*>(expected)[i] & 0xff);
        }

        return ::testing::AssertionFailure() \
            << "Value of: std::memcmp(" << expr1 << ", " << expr2 << ", " << expr3 << ") == 0\n" \
            << "  Actual: " << ss1.str().c_str() << "\n" \
            << "Expected: " << ss2.str().c_str();
    }
}

inline
::testing::AssertionResult CmpHelperARRAYZERO(const char* expr1,
                                              const char* expr2,
                                              const void* target,
                                              size_t size)
{
    NN_UNUSED(expr2);

    const uint8_t* ptr = static_cast<const uint8_t*>(target);

    for (int i = 0; i < static_cast<int>(size); ++i)
    {
        if (ptr[i] != 0)
        {
            std::stringstream ss;
            ss << std::hex;
            for (int j = 0; j < static_cast<int>(size); j++)
            {
                ss << std::setw(2) << std::setfill('0') << (ptr[j] & 0xff);
            }
            return ::testing::AssertionFailure() << expr1 << " (" << size << " bytes) is not zero" << "\n  Actual:" << ss.str().c_str();
        }
    }

    return ::testing::AssertionSuccess();
}

inline
::testing::AssertionResult CmpHelperARRAYNONZERO(const char* expr1,
                                                 const char* expr2,
                                                 const void* target,
                                                 size_t size)
{
    NN_UNUSED(expr2);

    const uint8_t* ptr = static_cast<const uint8_t*>(target);

    for (int i = 0; i < static_cast<int>(size); ++i)
    {
        if (ptr[i] != 0)
        {
            return ::testing::AssertionSuccess();
        }
    }

    return ::testing::AssertionFailure() << expr1 << " (" << size << " bytes) is all zero";
}

#define EXPECT_ARRAY_EQ(actual, expected, size) \
    EXPECT_PRED_FORMAT3(CmpHelperARRAYEQ, actual, expected, size)

#define EXPECT_ARRAY_ZERO(target, size) \
    EXPECT_PRED_FORMAT2(CmpHelperARRAYZERO, target, size)

#define EXPECT_ARRAY_NONZERO(target, size) \
    EXPECT_PRED_FORMAT2(CmpHelperARRAYNONZERO, target, size)
