﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/crypto/crypto_Csrng.h>

#include "testCrypto_Util.h"

namespace
{
    nn::Bit8 g_Buffer[3 * 1024 * 1024];
}

TEST(CsrngTest, Basic)
{
    nn::Bit8 buffer1[64];
    nn::Bit8 buffer2[64];

    // 呼び出せることのテスト
    // スタックでもスタティックでも使えることのテスト
    nn::crypto::GenerateCryptographicallyRandomBytes(buffer1, sizeof(buffer1));
    nn::crypto::GenerateCryptographicallyRandomBytes(g_Buffer, sizeof(g_Buffer));

    // 0 ではないことのテスト
    std::memset(buffer2, 0, sizeof(buffer2));
    EXPECT_TRUE( std::memcmp(buffer1, buffer2, sizeof(buffer1)) != 0 );


    // XOR とっても 0 ではないことのテスト
    nn::crypto::GenerateCryptographicallyRandomBytes(buffer2, sizeof(buffer2));
    for( int i = 0; i < sizeof(buffer1); ++i )
    {
        buffer1[i] ^= buffer2[i];
    }
    std::memset(buffer2, 0, sizeof(buffer2));
    EXPECT_TRUE( std::memcmp(buffer1, buffer2, sizeof(buffer1)) != 0 );
}
