﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nn/nn_Log.h>

#include <nn/os.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/bluetooth/bluetooth_Api.h>

namespace
{
    nn::os::SystemEventType g_SystemEvent;
    nn::os::SystemEventType g_SystemEventForHid;
}

TEST(InitializationShutdownTest, BT_TC_1_1)
{
    for(int i = 0; i < 10; i++)
    {
      NN_LOG("\n-----------------------------------------------------------------------\n");
      NN_LOG("Iteration %d\n", i);

      NN_LOG("\n-----------------------------------------------------------------------\n");
      NN_LOG("Starting up\n");

      NN_LOG("InitializeBluetoothDriver\n");
      nn::bluetooth::InitializeBluetoothDriver();
      NN_LOG("InitializeBluetooth\n");
      ASSERT_TRUE( nn::bluetooth::InitializeBluetooth(&g_SystemEvent).IsSuccess() );
      NN_LOG("EnableBluetooth\n");
      ASSERT_TRUE(nn::bluetooth::EnableBluetooth().IsSuccess() );
      NN_LOG("InitializeHid\n");
      ASSERT_TRUE( nn::bluetooth::InitializeHid(&g_SystemEventForHid).IsSuccess() );

      NN_LOG("Sleeping...\n");
      nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));

      NN_LOG("\n-----------------------------------------------------------------------\n");
      NN_LOG("Shutting down\n");
      nn::os::DestroySystemEvent(&g_SystemEvent);
      nn::os::DestroySystemEvent(&g_SystemEventForHid);
      NN_LOG("CleanupHid\n");
      ASSERT_TRUE(nn::bluetooth::CleanupHid().IsSuccess() );
      NN_LOG("DisableBluetooth\n");
      ASSERT_TRUE(nn::bluetooth::DisableBluetooth().IsSuccess() );
      NN_LOG("CleanupBluetooth\n");
      ASSERT_TRUE(nn::bluetooth::CleanupBluetooth().IsSuccess() );
      NN_LOG("FinalizeBluetoothDriver\n");
      nn::bluetooth::FinalizeBluetoothDriver();
    }

    NN_LOG("Test complete\n");
}
