﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nnt/nntest.h>
#include <nn/bluetooth/bluetooth_AddressTypes.h>
#include <nn/bluetooth/bluetooth_LeTypes.h>

namespace nnt { namespace bluetooth { namespace common {
    /**
     * @brief           テスト全体を末期化します
     *
     * @details         テスト終了時に 1 度だけ呼んでください
     */
    void Finalize();

    /**
     * @brief           各テストの開始処理を行います
     *
     * @details         各テストの開始時に呼んでください。
     *                  以下の処理を行います。
     *                  - Radio On
     */
    void SetUp();

    /**
     * @brief           各テストの終了処理を行います
     *
     * @details         各テストの終了時に呼んでください。
     *                  以下の処理を行います。
     *                  - Radio On
     */
    void TearDown();

    /**
     * @brief           Radio On/Off を切り替えます
     *
     * @param[in]       enable              Radio を On にするか Off にするか
     */
    void EnableRadio(bool enable);

    const nn::bluetooth::Address InvalidAddress = { { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } };

    const nn::bluetooth::GattAttributeUuid InvalidUuid =
    {
        .length     = nn::bluetooth::GattAttributeUuidLength_128,
        .uu.uuid128 = { 0x00 }
    };
}}}   // namespace nnt::bluetooth::common;
