﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/btm/system/btm_SystemApi.h>
#include <nn/bluetooth/bluetooth_LeApi.h>

#include <nn/nn_Log.h>

#include "testBle_Common.h"

namespace
{
    bool g_IsInitialized = false;                   // Initialize() が呼ばれたかどうか

    nn::os::SystemEventType g_RadioEvent;           //!< Radio Event

    void Initialize()
    {
        if (!g_IsInitialized)
        {
            nn::bluetooth::InitializeBle();

            nn::btm::system::AcquireRadioEvent(&g_RadioEvent);

            g_IsInitialized = true;
        }
    }
}

namespace nnt { namespace bluetooth { namespace common {
    void Finalize()
    {
        if (g_IsInitialized)
        {
            nn::os::DestroySystemEvent(&g_RadioEvent);

            g_IsInitialized = false;
        }
    }

    void SetUp()
    {
        Initialize();

        EnableRadio(true);
    }

    void TearDown()
    {
        EnableRadio(true);
    }

    void EnableRadio(bool enable)
    {
        nn::os::ClearSystemEvent(&g_RadioEvent);

        if (nn::btm::system::IsRadioEnabled() != enable)
        {
            nn::btm::system::EnableRadio(enable);

            nn::os::WaitSystemEvent(&g_RadioEvent);

            EXPECT_EQ(nn::btm::system::IsRadioEnabled(), enable);
        }
    }

}}} // namespace nnt::bluetooth::common
