﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testBcat_Common.h"

#include <nn/bcat/detail/service/core/bcat_MetaView.h>

using namespace nn::bcat::detail::service::core;

namespace
{
    const nn::ApplicationId AppId = {0x0100db60000a8000};
}

TEST(MetaView, Initialize)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHost("bcat-dc-00", "C:\\siglo\\bcat-dc-00"));
    DeliveryCacheStorageManager::GetInstance().EnableTestMode();

    ASSERT_RESULT_SUCCESS(DeliveryCacheStorageManager::GetInstance().Mount(AppId));
}

TEST(MetaView, File)
{
    FileMetaView view;

    for (int i = 0; i < nn::bcat::DeliveryCacheFileCountMaxPerDirectory; i++)
    {
        nn::bcat::detail::FileMeta entry = {};

        nn::util::SNPrintf(entry.name.value, sizeof (entry.name.value), "file%03d", i);
        entry.dataId = static_cast<uint64_t>(i);

        ASSERT_RESULT_SUCCESS(view.AddOrUpdate(entry));

        entry.dataId += 10000;
        ASSERT_RESULT_SUCCESS(view.AddOrUpdate(entry));

        EXPECT_EQ(view.GetCount(), i + 1);

        ASSERT_RESULT_SUCCESS(view.Search(nullptr, &entry, entry.name.value));
    }

    ASSERT_RESULT_SUCCESS(FileMetaView::SaveToDeliveryCacheStorage(view, AppId, "dir1"));

    view.Clear();

    ASSERT_RESULT_SUCCESS(FileMetaView::LoadFromDeliveryCacheStorage(&view, AppId, "dir1"));

    static nn::bcat::detail::FileMeta s_Entries[nn::bcat::DeliveryCacheFileCountMaxPerDirectory] = {};
    int count = 0;

    view.GetList(&count, s_Entries, nn::bcat::DeliveryCacheFileCountMaxPerDirectory);
    EXPECT_TRUE(count == nn::bcat::DeliveryCacheFileCountMaxPerDirectory);

    for (int i = 0; i < count; i++)
    {
        nn::bcat::detail::FileMeta entry = {};

        nn::util::SNPrintf(entry.name.value, sizeof (entry.name.value), "file%03d", i);
        entry.dataId = static_cast<uint64_t>(10000 + i);

        EXPECT_TRUE(std::memcmp(&entry, &s_Entries[i], sizeof (entry)) == 0);
    }

    for (int i = 0; i < count; i++)
    {
        nn::bcat::FileName name = {};
        nn::util::SNPrintf(name.value, sizeof (name.value), "file%03d", i);

        ASSERT_RESULT_SUCCESS(view.Remove(name.value));

        nn::bcat::detail::FileMeta entry = {};
        ASSERT_RESULT(view.Search(nullptr, &entry, name.value), nn::bcat::ResultNotFound);
    }

    view.GetList(&count, s_Entries, nn::bcat::DeliveryCacheFileCountMaxPerDirectory);
    EXPECT_TRUE(count == 0);

    ASSERT_RESULT_SUCCESS(FileMetaView::SaveToDeliveryCacheStorage(view, AppId, "dir1"));
    ASSERT_RESULT_SUCCESS(FileMetaView::SaveToDeliveryCacheStorage(view, AppId, "dir1"));

    EXPECT_TRUE(view.GetCount() == 0);
}

TEST(MetaView, Directory)
{
    DirectoryMetaView view;

    for (int i = 0; i < nn::bcat::DeliveryCacheDirectoryCountMax; i++)
    {
        nn::bcat::detail::DirectoryMeta entry = {};

        nn::util::SNPrintf(entry.name.value, sizeof (entry.name.value), "dir%03d", i);

        ASSERT_RESULT_SUCCESS(view.AddOrUpdate(entry));
        ASSERT_RESULT_SUCCESS(view.AddOrUpdate(entry));

        EXPECT_EQ(view.GetCount(), i + 1);

        ASSERT_RESULT_SUCCESS(view.Search(nullptr, &entry, entry.name.value));
    }

    ASSERT_RESULT_SUCCESS(DirectoryMetaView::SaveToDeliveryCacheStorage(view, AppId));

    view.Clear();

    ASSERT_RESULT_SUCCESS(DirectoryMetaView::LoadFromDeliveryCacheStorage(&view, AppId));

    static nn::bcat::detail::DirectoryMeta s_Entries[nn::bcat::DeliveryCacheDirectoryCountMax] = {};
    int count = 0;

    view.GetList(&count, s_Entries, nn::bcat::DeliveryCacheDirectoryCountMax);
    EXPECT_TRUE(count == nn::bcat::DeliveryCacheDirectoryCountMax);

    for (int i = 0; i < count; i++)
    {
        nn::bcat::detail::DirectoryMeta entry = {};

        nn::util::SNPrintf(entry.name.value, sizeof (entry.name.value), "dir%03d", i);

        EXPECT_TRUE(std::memcmp(&entry, &s_Entries[i], sizeof (entry)) == 0);
    }

    for (int i = 0; i < count; i++)
    {
        nn::bcat::DirectoryName name = {};
        nn::util::SNPrintf(name.value, sizeof (name.value), "dir%03d", i);

        ASSERT_RESULT_SUCCESS(view.Remove(name.value));

        nn::bcat::detail::DirectoryMeta entry = {};
        ASSERT_RESULT(view.Search(nullptr, &entry, name.value), nn::bcat::ResultNotFound);
    }

    view.GetList(&count, s_Entries, nn::bcat::DeliveryCacheDirectoryCountMax);
    EXPECT_TRUE(count == 0);

    ASSERT_RESULT_SUCCESS(DirectoryMetaView::SaveToDeliveryCacheStorage(view, AppId));
    ASSERT_RESULT_SUCCESS(DirectoryMetaView::SaveToDeliveryCacheStorage(view, AppId));

    EXPECT_TRUE(view.GetCount() == 0);
}
