﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testBcat_Common.h"

#include <nn/bcat/detail/service/core/bcat_DeliveryCacheDownloader.h>
#include <nn/bcat/detail/service/core/bcat_DeliveryCacheStorageManager.h>
#include <nn/bcat/detail/service/core/bcat_DirectorySynchronizer.h>
#include <nn/socket.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/account/account_ApiForSystemServices.h>

using namespace nn::bcat::detail::service::core;

// MEMO: td1 環境で動作確認すること。

namespace
{
    const nn::ApplicationId AppId = {0x0100db60000a8000};
    const uint32_t AppVersion = 0;

    const char* Passphrase = "e3ac0d7a05b67c3e228369dff4aba298c645e8bd356ae45ac4910fac93d20d13";
}

namespace
{
    nn::socket::ConfigDefaultWithMemory g_SocketConfigWithMemory;

    nn::Bit8 g_WorkBuffer[256 * 1024];
}

TEST(DeliveryCacheDownloader, Initialize)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHost("bcat-sys", "C:\\siglo\\bcat-sys"));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHost("bcat-dl", "C:\\siglo\\bcat-dl"));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHost("bcat-dc-00", "C:\\siglo\\bcat-dc-00"));
    FileSystem::EnableTestMode();
    DeliveryCacheStorageManager::GetInstance().EnableTestMode();
}

TEST(DeliveryCacheDownloader, Do)
{
    nn::account::InitializeForSystemService();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::InitializeSystem());
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::socket::Initialize(g_SocketConfigWithMemory));

    {
        ASSERT_RESULT_SUCCESS(DeliveryCacheStorageManager::GetInstance().Mount(AppId));

        NN_UTIL_SCOPE_EXIT
        {
            DeliveryCacheStorageManager::GetInstance().Unmount(AppId);
        };

        if (DirectorySynchronizer::IsTransactionCreated(AppId))
        {
            NN_FUNCTION_LOCAL_STATIC(DirectorySynchronizer, s_Synchronizer);

            ASSERT_RESULT_SUCCESS(s_Synchronizer.Recover(AppId, g_WorkBuffer, sizeof (g_WorkBuffer)));
        }
    }

    ASSERT_RESULT_SUCCESS(DeliveryCacheStorageManager::GetInstance().RequestSavePassphrase(AppId, Passphrase));

    NN_FUNCTION_LOCAL_STATIC(DeliveryCacheDownloader, s_Downloader);

    nn::Result result = s_Downloader.Download(IdIssuer::GetInstance().IssueTaskId(), AppId, AppVersion, true, false,
        g_WorkBuffer, sizeof (g_WorkBuffer));

    if (nn::bcat::ResultNintendoAccountNotLinked::Includes(result))
    {
        NN_LOG("[Warning] Please link Nintendo account or register Network service account.\n");
    }

    ASSERT_RESULT_SUCCESS(result);
}
