﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/ae.h>

#include "../Common/applet_Common.h"

//-----------------------------------------------------------------------------
//  制御用のメインループです。
//
bool EventViewerMain(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    auto message = nn::ae::WaitForNotificationMessage(pEvent);
    PrintAppletMessage("SA", message);
    ProcessMessage("SA", message);

    return message == nn::ae::Message_Exit;
}

//-----------------------------------------------------------------------------

NN_ALIGNAS(4096) char g_MallocBuffer[0x200000];
extern "C" void nninitStartup()
{
    nn::os::SetMemoryHeapSize( 0x200000 );
    nn::init::InitializeAllocator(g_MallocBuffer, sizeof(g_MallocBuffer));
}

//-----------------------------------------------------------------------------
//  メイン関数です。
//
void SystemAppletMenuMain(nn::ae::SystemAppletParameters* param)
{
    NN_UNUSED(param);

    NN_LOG("SA: Launched SystemAppletMenu for Event Viewer.\n");

    nn::os::SystemEventType event;
    nn::ae::InitializeNotificationMessageEvent(&event);

    //--------------------------------------------

    for (;;)
    {
        auto isExit = EventViewerMain(&event);
        if (isExit)
        {
            break;
        }
    }

    //----------

    NN_LOG("SA: Exit SystemAppletMenu from now.\n");
}

extern "C" void nnMain()
{
    NN_LOG("SA: Invoke nn::ae::InvokeSystemAppletMain().\n");

    nn::ae::InvokeSystemAppletMain(nn::ae::AppletId_SystemAppletMenu, SystemAppletMenuMain);
}

