﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/oe.h>
#include <nn/oe/oe_DisplayResolutionApis.h>

extern "C" void nnMain()
{
    nn::oe::Initialize();

    // SIGLO-69853: ハンドルリークしないかの確認
    for (int i=0; i<1000; ++i)
    {
        nn::os::SystemEvent event;
        nn::oe::GetDefaultDisplayResolutionChangeEvent(&event);
    }

    nn::os::SystemEvent event;
    nn::oe::GetDefaultDisplayResolutionChangeEvent(&event);

    int width, height;
    nn::oe::GetDefaultDisplayResolution( &width, &height );
    NN_LOG("DefaultDisplayResolution=(%d, %d)\n", width , height);

    for(;;)
    {
        event.Wait();
        nn::oe::GetDefaultDisplayResolution( &width, &height );
        NN_LOG("DefaultDisplayResolution was changed to (%d, %d)\n", width, height);
    }
}
