﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/aoc.h>

#include <nn/nn_ApplicationId.h>
#include <nn/aoc/aoc_PrivateApi.h>
#include <nn/aoc/aoc_SystemApi.h>

namespace {
    class AocBasicTest : public testing::Test
    {
    protected:
        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }

        static void SetUpTestCase()
        {
        }

        static void TearDownTestCase()
        {
        }


    private:
    };



}

#if defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN)

TEST_F(AocBasicTest, Initialize)
{
    EXPECT_DEATH_IF_SUPPORTED(nn::aoc::Initialize(), "");
}



#elif defined(NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON)
TEST_F(AocBasicTest, Initialize)
{

    int offset = 0;
    int count = 1;
    nn::aoc::AddOnContentIndex out;
    nn::ApplicationId appId = { 0 };

    EXPECT_DEATH_IF_SUPPORTED(nn::aoc::CountAddOnContent(appId), "");
    EXPECT_DEATH_IF_SUPPORTED(nn::aoc::ListAddOnContent(&out, offset, count, appId), "");

    nn::aoc::CountAddOnContent(appId);
    nn::aoc::ListAddOnContent(&out, offset, count, appId);

    EXPECT_DEATH_IF_SUPPORTED(nn::aoc::CountAddOnContent(), "");
    EXPECT_DEATH_IF_SUPPORTED(nn::aoc::ListAddOnContent(&out, offset, count), "");
}

TEST_F(AocBasicTest, GetAocBaseId)
{
    nn::ApplicationId appId = { 0x0005000c10000000ull };

    EXPECT_EQ(appId.value + 0x1000, nn::aoc::GetAddOnContentBaseId(appId));

    // TODO: ns 側で LaunchProperty が格納されるようになってから有効化
    //EXPECT_EQ(appId.value + 0x1000, nn::aoc::GetAddOnContentBaseId());
}

#endif
