﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/font.h>

#include "eval_Screen.h"
#include "detail/eval_ScreenController.h"

namespace nnt { namespace eval {

namespace {

bool g_IsInitialized = false;

} // namespace

void Screen::Initialize() NN_NOEXCEPT
{
    detail::Initialize();
    g_IsInitialized = true;
}

void Screen::Finalize() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsInitialized, "Please call Initialize()\n");
    detail::Finalize();
    g_IsInitialized = false;
}

void Screen::Draw() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsInitialized, "Please call Initialize()\n");
    detail::Draw();
}

nn::gfx::util::DebugFontTextWriter* Screen::GetDebugFontTextWriter() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsInitialized, "Please call Initialize()\n");
    return detail::GetDebugFontTextWriter();
}

}}; // namespace nnt::eval

