﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Color.h>
#include <nvn/nvn.h>

namespace nnt{ namespace album{ namespace scene{

    void ClearTexture(NVNcommandBuffer* pCommandBuffer, NVNtexture* pTexture, const nn::util::Color4f& color) NN_NOEXCEPT;

    //--------------

    struct CopyTextureParameter
    {
    public:
        static CopyTextureParameter GetPreset() NN_NOEXCEPT
        {
            CopyTextureParameter param;
            param.SetPreset();
            return param;
        }
        void SetPreset() NN_NOEXCEPT;
    public:
        int dstX;
        int dstY;
        int dstWidth;
        int dstHeight;
        NVNtextureView* pDstView;
        int srcX;
        int srcY;
        int srcWidth;
        int srcHeight;
        NVNtextureView* pSrcView;
    };

    void CopyTexture(NVNcommandBuffer* pCommandBuffer, NVNtexture* pDstTexture, NVNtexture* pSrcTexture, const CopyTextureParameter& param) NN_NOEXCEPT;

    //--------------

    struct CopyBufferToTextureParameter
    {
    public:
        static CopyBufferToTextureParameter GetPreset() NN_NOEXCEPT;
        void SetPreset() NN_NOEXCEPT;
    public:
        int dstX;
        int dstY;
        int dstWidth;
        int dstHeight;
        NVNtextureView* pDstView;
    };

    void CopyBufferToTexture(NVNcommandBuffer* pCommandBuffer, NVNtexture* pDstTexture, NVNbuffer* pSrcBuffer, ptrdiff_t srcOffset, size_t srcSize, const CopyBufferToTextureParameter& param) NN_NOEXCEPT;

    //--------------

    struct RotationBoxParameter
    {
    public:
        void SetPreset() NN_NOEXCEPT;

    public:
        float boxSize;
        nn::util::Color4f boxColor;
        float trajectoryCenterX;
        float trajectoryCenterY;
        float trajectoryRadius;
        float angularVelocity;
        float initialAngle;
    };

    void DrawRotationBox(NVNcommandBuffer* pCommandBuffer, NVNtexture* pTexture, NVNtextureView* pTexView, const RotationBoxParameter& param, float time) NN_NOEXCEPT;

    //--------------

    void DrawRotationBoxScene(NVNcommandBuffer* pCommandBuffer, NVNtexture* pTexture, NVNtextureView* pTexView, float time) NN_NOEXCEPT;

    //--------------

    struct DrawStringParameter
    {
    public:
        float posX;
        float posY;
        float size;
        nn::util::Color4f color;
    };

    void DrawChar(
        NVNcommandBuffer* pCommandBuffer,
        NVNtexture* pTexture,
        NVNtextureView* pTexView,
        char c,
        float posX,
        float posY,
        float size,
        const nn::util::Color4f& color
    ) NN_NOEXCEPT;

    void DrawString(
        NVNcommandBuffer* pCommandBuffer,
        NVNtexture* pTexture,
        NVNtextureView* pTexView,
        const char* str,
        float posX,
        float posY,
        float size,
        const nn::util::Color4f& color
    ) NN_NOEXCEPT;

    void DrawString(
        NVNcommandBuffer* pCommandBuffer,
        NVNtexture* pTexture,
        NVNtextureView* pTexView,
        const char* str,
        const DrawStringParameter& param
    ) NN_NOEXCEPT;
}}}
