﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/user/account_UserRegistry.h>
#include <nn/account/profile/account_ProfileStorage.h>

#include <memory>

namespace nnt { namespace account {

// オブジェクトの取得
inline std::shared_ptr<nn::account::user::UserRegistry> CreateRegistryManager() NN_NOEXCEPT
{
    return std::make_shared<nn::account::user::UserRegistry>();
}
inline std::shared_ptr<nn::account::profile::ProfileStorage> CreateProfileStorage() NN_NOEXCEPT
{
    return std::make_shared<nn::account::profile::ProfileStorage>();
}

}} // ~namesapce nnt::account
