﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "baas/account_BaasRegistrationAdaptor.h"
#include <nn/account/baas/account_BaasUserInfoHolder.h>

#include "detail/account_UuidUtil.h"
#include <nn/account/json/account_RapidJsonApi.h>
#include <nn/account/json/account_RapidJsonStream.h>
#include <nn/account/account_ResultForAdministrators.h>

#include "testAccount_Mounter.h"
#include "testAccount_Util.h"
#include "testAccount_JsonPrintAdaptor.h"
#include "testAccount_RapidJsonInputStream.h"

#include <nnt/nntest.h>

#include <nn/nn_Log.h>

namespace a = nn::account;
namespace t = nnt::account;

#define NNT_ACCOUNT_ENABLE_BAAS_REGISTRATION
#define NNT_ACCOUNT_ENABLE_BAAS_ERASURE

#if defined(NNT_ACCOUNT_ENABLE_BAAS_REGISTRATION)
namespace baasRegistration
{
const char Input[] =
    "{\"country\":\"\",\"etag\":\"\\\"e6c98dcb6cc931e6-698679167c0089e7\\\"\",\""
    "thumbnailUrl\":\"\",\"friendsUpdatedAt\":1458268901,\"links\":{},\"createdA"
    "t\":1458268901,\"blocksUpdatedAt\":1458268901,\"presence\":{\"updatedAt\":1"
    "458268901,\"extras\":{\"foaf\":{},\"friends\":{},\"self\":{},\"favoriteFrie"
    "nds\":{},\"everyone\":{}},\"state\":\"OFFLINE\"},\"extras\":{\"favoriteFrie"
    "nds\":{},\"self\":{},\"friends\":{},\"foaf\":{},\"everyone\":{}},\"updatedA"
    "t\":1458268901,\"birthday\":\"0000-00-00\",\"id\":\"e6c98dcb6cc931e6\",\"ni"
    "ckname\":\"\",\"permissions\":{\"personalNotification\":true,\"personalAnal"
    "yticsUpdatedAt\":1458268901,\"friends\":\"EVERYONE\",\"presence\":\"SELF\","
    "\"friendRequestReception\":true,\"personalAnalytics\":true,\"personalNotifi"
    "cationUpdatedAt\":1458268901},\"deviceAccounts\":[{\"id\":\"02441c80ed579bf"
    "1\",\"password\":\"G5cih4ZIeGYBSSQ4HJ09Pr0846aGb7XkAM5y5SbV\"}]}";
struct BaasCredentialWithTerminator
{
    uint64_t networkServiceAccountId;
    uint64_t loginId;
    char loginPassword[a::baas::BaasLoginPasswordLength + 1];

};
BaasCredentialWithTerminator Expect = { 0xe6c98dcb6cc931e6ull, 0x02441c80ed579bf1ull, "G5cih4ZIeGYBSSQ4HJ09Pr0846aGb7XkAM5y5SbV" };

void RunTest(const BaasCredentialWithTerminator& expect, const char* json) NN_NOEXCEPT
{
    t::MemoryInputStreamForRapidJson stream;
    stream.Set(json, strlen(json));

    a::baas::DeviceAccountRegistrationAdaptor adaptor;
    NNT_ACCOUNT_ASSERT_RESULT_SUCCESS(nn::account::json::ImportJsonByRapidJson(adaptor, stream));

    NNT_ACCOUNT_ASSERT_RESULT_SUCCESS(adaptor.Adapt(200));
    auto id = adaptor.GetId();
    auto credential = adaptor.GetCredential();

    ASSERT_EQ(expect.networkServiceAccountId, id.id);
    ASSERT_EQ(expect.loginId, credential.loginId);
    ASSERT_TRUE(std::strncmp(expect.loginPassword, credential.loginPassword, sizeof(credential.loginPassword)) == 0);
}
} // ~namespace baasRegistration
TEST(AccountAdaptor, BaasDaRegistration)
{
    baasRegistration::RunTest(baasRegistration::Expect, baasRegistration::Input);
}
#endif // NNT_ACCOUNT_ENABLE_BAAS_REGISTRATION

#if defined(NNT_ACCOUNT_ENABLE_BAAS_ERASURE)
namespace baasErasure
{
const char Input[] = "";

void RunTest(const char* json) NN_NOEXCEPT
{
    t::MemoryInputStreamForRapidJson stream;
    stream.Set(json, strlen(json));

    // 削除
    a::baas::BaasDeleteAdaptor adaptor;
    NNT_ACCOUNT_ASSERT_RESULT_INCLUDED(a::json::ResultJsonEmpty, nn::account::json::ImportJsonByRapidJson(adaptor, stream));
    NNT_ACCOUNT_ASSERT_RESULT_SUCCESS(adaptor.Adapt(204));
}
} // ~namespace baasErasure
TEST(AccountAdaptor, BaasDaErasure)
{
    baasErasure::RunTest(baasErasure::Input);
}
#endif // NNT_ACCOUNT_ENABLE_BAAS_ERASURE
