﻿# coding: utf-8
import clr
clr.AddReference("System.Windows.Forms")

def Filter(target):
	texture_info = target.Document.SelectSingleNode("//texture_info")
	if texture_info:
		target.Result = int(texture_info.GetAttribute("size"))

def PostFilter(targets):
	total_size = 0
	file_count = 0
	for target in targets:
		if target.Result:
			total_size += target.Result
			file_count += 1

	print("%.1f MBytes\n%.1f KBytes\n%d Bytes\n%d textures size" %(total_size / 1024.0 / 1024.0, total_size / 1024.0, total_size, file_count))
