﻿# coding: utf-8
from System.IO import *

def Filter(target):
	target.Result = ""
	texture_info = target.Document.SelectSingleNode("//texture_info")
	if texture_info.GetAttribute("hint") != "normal":
		return

	error = ""
	for original_image in target.Document.SelectNodes("//original_image"):
		format = original_image.GetAttribute("format")
		comp_count = 4
		if format == "rgb8":
			comp_count = 3
		elif format != "rgba8":
			continue

		stream_index = int(original_image.GetAttribute("stream_index"))
		error = CheckStream(target.Streams[stream_index], comp_count)
		if error != "":
			break

	if error != "":
		target.Result = "\"%s\",\"%s\",\"%s\"\r\n" % (
			target.FileName, error, target.FullPath)
		print(target.Result)
#	else:
#		target.Result = "\"%s\",\"\",\"%s\"\r\n" % (
#			target.FileName, target.FullPath)

def CheckStream(stream, comp_count):
	i = 0
	while i < stream.ByteData.Count:
		rc = stream.ByteData[i]
		gc = stream.ByteData[i + 1]
		bc = stream.ByteData[i + 2]
		r = rc - 128
		g = gc - 128
		b = bc - 128

		if b < 0:
			return "Negative Z RGB(%d %d %d)" % (rc, gc, bc)

		sqrd_len = r * r + g * g + b * b

		if sqrd_len > 16641: # 129 * 129
			return "Long Normal RGB(%d %d %d) sqrd_len=%d" % (rc, gc, bc, sqrd_len)

		if sqrd_len < 15876: # 126 * 126
			return "Short Normal RGB(%d %d %d) sqrd_len=%d" % (rc, gc, bc, sqrd_len)

		i += comp_count
	return ""

def PostFilter(targets):
	result = ("\"FileName\",\"Error\",\"FullPath\"\r\n")
	for target in targets:
		result += target.Result
	File.WriteAllText(ScriptArgument, result);
