﻿# coding: utf-8
from System.IO import *

# ファイル単位のフィルタで最適化情報を収集
def Filter(target):

	# マテリアル圧縮
	compress_material = ""
	process_log = GetProcessLog(target, "compress_material")
	if (process_log):
		compress_material = process_log.InnerText

	# ボーン圧縮
	compress_bone = ""
	process_log = GetProcessLog(target, "compress_bone_cull")
	if (process_log):
		compress_bone = "cull(" + process_log.InnerText + ") "

	process_log = GetProcessLog(target, "compress_bone_merge")
	if (process_log):
		compress_bone = "merge(" + process_log.InnerText + ") "

	process_log = GetProcessLog(target, "compress_bone_unite_child")
	if (process_log):
		compress_bone = "unite_child(" + process_log.InnerText + ") "

	process_log = GetProcessLog(target, "compress_bone_unite")
	if (process_log):
		compress_bone = "unite(" + process_log.InnerText + ") "

	process_log = GetProcessLog(target, "compress_bone_unite_all")
	if (process_log):
		compress_bone = "unite_all(" + process_log.InnerText + ") "

	# シェイプ圧縮
	compress_shape = ""
	process_log = GetProcessLog(target, "compress_shape")
	if (process_log):
		compress_shape = process_log.InnerText

	# マージ
	merge = ""
	process_log = GetProcessLog(target, "merge")
	if (process_log):
		merge = process_log.GetAttribute("argument")

	# プリミティブ最適化
	optimize_primitive = ""
	process_log = GetProcessLog(target, "optimize_primitive")
	if (process_log):
		optimize_primitive = process_log.InnerText

	# 量子化分析
	quantization_analysis = ""
	process_log = GetProcessLog(target, "quantization_analysis")
	if (process_log):
		quantization_analysis = process_log.InnerText

	# 近似頂点削除
	delete_near_vertex = ""
	process_log = GetProcessLog(target, "delete_near_vertex")
	if (process_log):
		delete_near_vertex = process_log.InnerText

	target.Result = "\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\r\n" % (
			target.FileName,
			compress_material,
			compress_bone,
			compress_shape,
			merge,
			optimize_primitive,
			quantization_analysis,
			delete_near_vertex,
			target.FullPath
		)

# <process_log> の取得
def GetProcessLog(target, process):
	return target.Document.SelectSingleNode(
		"/nw4f_3dif/model/process_log_array/process_log[@process=\"" + process + "\"]")

# ポストフィルタで CSV 形式による書き出し
def PostFilter(targets):
	result = (
		"\"FileName\"," +
		"\"compress_material\"," +
		"\"compress_bone\"," +
		"\"compress_shape\"," +
		"\"merge\"," +
		"\"optimize_primitive\"," +
		"\"quantization_analysis\"," +
		"\"delete_near_vertex\"," +
		"\"FullPath\"\r\n"
	)
	for target in targets:
		result += target.Result
	File.WriteAllText(ScriptArgument, result);
