# coding: utf-8
import System

# モデルの全頂点カラーを 0 から 1 にクランプするサンプルです。

def Filter(target):
	for vtx_attrib in target.Document.SelectNodes("//vtx_attrib"):
		if "_c" in vtx_attrib.GetAttribute("name"):
			stream_index = int(vtx_attrib.GetAttribute("stream_index"))
			stream = target.Streams[stream_index]
			print("Clamp target attribute: name = %s, stream_index = %d"%(vtx_attrib.GetAttribute("name"), stream_index))
			for elem_index in range(0, stream.FloatData.Count):
				value = float(stream.FloatData[elem_index])
				stream.FloatData[elem_index] = System.Single(0.0 if value < 0.0 else 1.0 if  value > 1.0 else value)

	target.Write()
