#version 440 core
#extension GL_NV_gpu_shader5:require

layout(location = 0) out vec4 color;
in vec2 v_texCoord;
in vec3 v_position;

uniform BlockSpecializedFS
{
    uint64_t u_bindlessTex[4];
    uint32_t u_textureStyle;
	uint32_t u_textureIndex;
};

void main() 
{
    // Regular texturing
    if(u_textureStyle == 0)
    {
        color = texture(sampler2D(u_bindlessTex[u_textureIndex]), v_texCoord.xy);
    }
    // Texture coordinate as texture
    else if(u_textureStyle == 1)
    {
        color = texture(sampler2D(u_bindlessTex[u_textureIndex]), v_texCoord.xy);
        color = color + vec4(v_texCoord.xy, 0, 1.0f);
		color = color / 2.0f;
    }
    // Position as texture
    else if(u_textureStyle == 2)
    {
        color = texture(sampler2D(u_bindlessTex[u_textureIndex]), v_texCoord.xy);
        color = color + vec4(v_position, 1.0f);
		color = color / 2.0f;
    }
	// Flip x and y tex coordinates
	else if(u_textureStyle == 3)
	{
		vec2 swappedCoords;
		swappedCoords.x = 1.0f - v_texCoord.x;
		swappedCoords.y = 1.0f - v_texCoord.y;
        color = texture(sampler2D(u_bindlessTex[u_textureIndex]), swappedCoords.xy);
	}
}
