#version 440 core
#extension GL_NV_gpu_shader5:require


in vec2 v_texCoord;

layout(binding = 0) uniform BlockColorFS
{
	vec4 u_color;
};

layout(binding = 1) uniform BlockSamplerFS
{
	uint64_t u_bindlessTex;
};

layout(location = 0) out vec4 color;

void main()
{
   vec4 texColor = texture2D(sampler2D(u_bindlessTex), v_texCoord);                         
   texColor.a    = smoothstep(0.0f, 1.0f, texColor.r);
   texColor  = vec4(1.0f, 1.0f, 1.0f, texColor.a);
   color  = u_color * texColor;
}