﻿function CreateExePath()
{
    Param
    (
        $SampleName,
        $Platform,
        $BuildVersion
    )

    return $SdkRoot + "\Samples\Outputs" + "\" + $Platform + "\Applications\" + $SampleName + "\" + $BuildVersion
}

function CreateExePathForPackage()
{
    Param
    (
        $SampleName,
        $Platform,
        $BuildVersion
    )

    $PlatformDir = ""
    switch($Platform)
    {
        "NX-NXFP2-a32"
        {
            $PlatformDir = "NX32"
        }
        "NX-NXFP2-a64"
        {
            $PlatformDir = "NX64"
        }
        "x64-v120"
        {
            $PlatformDir = "x64"
        }
        "x64-v140"
        {
            $PlatformDir = "x64"
        }
        "x64-v141"
        {
            $PlatformDir = "x64"
        }
        "Win32-v120"
        {
            $PlatformDir = "Win32"
        }
        "Win32-v140"
        {
            $PlatformDir = "Win32"
        }
        "Win32-v141"
        {
            $PlatformDir = "Win32"
        }
    }
    
    $BuildVerDir = ""
    if ( ($Platform -ceq "NX-NXFP2-a64") -or ($Platform -ceq "NX-NXFP2-a32") )
    {
        switch($BuildVersion)
        {
            "Debug"
            {
                $BuildVerDir = "NX_Debug"
            }
            "Develop"
            {
                $BuildVerDir = "NX_Develop"
            }
            "Release"
            {
                $BuildVerDir = "NX_Release"
            }
        }
    }
    elseif ( ($Platform -ceq "x64-v141") -or ($Platform -ceq "Win32-v141") )
    {
        switch($BuildVersion)
        {
            "Debug"
            {
                $BuildVerDir = "VS2017_Debug"
            }
            "Develop"
            {
                $BuildVerDir = "VS2017_Develop"
            }
            "Release"
            {
                $BuildVerDir = "VS2017_Release"
            }
        }
    }
    elseif ( ($Platform -ceq "x64-v140") -or ($Platform -ceq "Win32-v140") )
    {
        switch($BuildVersion)
        {
            "Debug"
            {
                $BuildVerDir = "VS2015_Debug"
            }
            "Develop"
            {
                $BuildVerDir = "VS2015_Develop"
            }
            "Release"
            {
                $BuildVerDir = "VS2015_Release"
            }
        }
    }
    elseif ( ($Platform -ceq "x64-v120") -or ($Platform -ceq "Win32-v120") )
    {
        switch($BuildVersion)
        {
            "Debug"
            {
                $BuildVerDir = "VS2013_Debug"
            }
            "Develop"
            {
                $BuildVerDir = "VS2013_Develop"
            }
            "Release"
            {
                $BuildVerDir = "VS2013_Release"
            }
        }
    }

    return $SdkRoot + "\Samples\Sources\Applications\" + $SampleName + "\Binaries\" + $PlatformDir + "\" + $BuildVerDir
}

function BootUpSample()
{
    Param
    (
        $Process,
        $SampleName,
        $Platform,
        $BuildVersion,
        $Target
    )


    if ( ($Platform -ceq "NX-NXFP2-a64") -or ($Platform -ceq "NX-NXFP2-a32") )
    {
        $ExeDir = ""
        if ($IsPackage -eq $true)
        {
            $ExeDir = CreateExePathForPackage $SampleName $Platform $BuildVersion
        }
        else
        {
            $ExeDir = CreateExePath $SampleName $Platform $BuildVersion
        }
        $ProgramPath = $ExeDir + "\" + $SampleName + ".nspd"

        Write-Host "BootUpSample : " $ProgramPath

        $Arguments = $ProgramPath + " " + "--target=" + $Target

        $pinfo = New-Object System.Diagnostics.ProcessStartInfo
        $pinfo.FileName = $RunOnTarget
        $pinfo.Arguments = $Arguments
        $pinfo.UseShellExecute = $false
        $pinfo.RedirectStandardError = $true
        $pinfo.RedirectStandardOutput = $true
        $Process.StartInfo = $pinfo
        $Process.Start()

        # InputDirector を起動
        &$InputDirectorStartScript

        # サンプルの起動待ち
        Start-Sleep -s 5
    }
    else
    {
        $ExeDir = ""
        if ($IsPackage -eq $true)
        {
            $ExeDir = CreateExePathForPackage $SampleName $Platform $BuildVersion
        }
        else
        {
            $ExeDir = CreateExePath $SampleName $Platform $BuildVersion
        }
        $ProgramPath = $ExeDir + "\" + $SampleName + ".exe"

        Write-Host "BootUpSample : " $ProgramPath
        
        $pinfo = New-Object System.Diagnostics.ProcessStartInfo
        $pinfo.FileName = $ProgramPath
        $pinfo.UseShellExecute = $false
        $pinfo.RedirectStandardError = $true
        $pinfo.RedirectStandardOutput = $true
        $Process.StartInfo = $pinfo
        $Process.Start()

        # InputDirector を停止
        &$InputDirectorStopScript
    }

    return
}

function RunSample()
{
    Param
    (
        $SampleName,
        $Platform,
        $BuildVersion,
        $Target
    )

    Write-Host "[$SampleName Test Start ]" -ForegroundColor Green
    Write-Host "Target: $Target, Platform: $Platform, BuildVersion: $BuildVersion" -ForegroundColor Cyan
    
    # サンプルを起動
    $p = New-Object System.Diagnostics.Process
    BootUpSample $p $SampleName $Platform $BuildVersion $Target
    
    # 対応する操作ログのファイルパスを生成
    $SampleOperationFilePath = $OperationDir + "\" + $SampleName + ".log"
    $CaptureOperationFilePath = $OperationDir + "\SaveMovie.log"
    $ExitOperationFilePath = $OperationDir + "\ExitSample.log"

    # ログを再生
    &$PlaybackScript $SampleOperationFilePath $Target
    # 動画キャプチャ(キャプチャ完了のために 4 秒待ちます)
    &$PlaybackScript $CaptureOperationFilePath $Target
    Start-Sleep -s 4
    # サンプル終了
    &$PlaybackScript $ExitOperationFilePath $Target
    
    
    # 終了コードを正しく取得するためにサンプルの終了を待つ
    if ( ($Platform -ceq "NX-NXFP2-a64") -or ($Platform -ceq "NX-NXFP2-a32") )
    {
        Wait-Process -Id ($p.Id)
    }

    # ログ出力フォルダの存在を確認しなければ作成
    $IsLogDirExist = Test-Path $LogDir
    if ($IsLogDirExist -eq $False)
    {
        New-Item $LogDir -itemType Directory
    }

    # 標準出力などをファイルに出力
    $CurrentTime = Get-Date -format "yyyyMMdd-HHmmss"
    $LogFileNameBase = $SampleName + "_" + $Platform + "_" + $Target + "_" + $BuildVersion

    $stdout = $p.StandardOutput.ReadToEnd()
    $stderr = $p.StandardError.ReadToEnd()

    $StdOutFile = $LogDir + "\" + $CurrentTime + "_" + "StdOut-" + $LogFileNameBase + ".log"
    $StdErrFile = $LogDir + "\" + $CurrentTime + "_" + "StdErr-" + $LogFileNameBase + ".log"

    $stdout | Out-File -FilePath $StdOutFile
    $stderr | Out-File -FilePath $StdErrFile

    # 成功 or 失敗を出力
    if ( $p.ExitCode -eq 0 )
    {
        return $True
    }
    else
    {
        return $False
    }
}
