﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdarg>
#include <nns/gfxLog.h>
#include <nn/util/util_FormatString.h>
#include "gfxLogLogOut.h"

namespace nns {
namespace gfxLog {
namespace detail {

/**
* @brief ログ出力と画面出力を行う関数です。
*
* @param[in]    format    フォーマット指定
* @details ログ出力と画面出力を行う関数です。実際の描画は行いません。
*/
void PrintLog(const char * format, ...) NN_NOEXCEPT
{
    const int BuffSize = 8192;
    char* buff = new char[BuffSize];
    va_list ap;
    va_start(ap, format);
    nn::util::VSNPrintf(buff, BuffSize, format, ap);
    va_end(ap);

    nns::gfxLog::LogOut::Log(buff);
    delete[] buff;
}
} // namespace detail
} // namespace gfxLog
} // namespace nns
