﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>

#include <nns/display0/display0_IDisplay0Driver.sfdl.h>

#include "display0_DriverSample.h"

namespace nns { namespace display0 {

//-----------------------------------------------------------------------------
//  IDisplay0Driver の実装用クラス
//-----------------------------------------------------------------------------

class Display0DriverImpl
{
private:
    Display0DriverSample    m_DriverSample;

public:
    void StartDisplay0(nn::sf::NativeHandle systemEventHandle) NN_NOEXCEPT;
    void StopDisplay0() NN_NOEXCEPT;
};

//-----------------------------------------------------------------------------

}}  // namespace nns::display0

